/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaValorParcela;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.Parcela;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.util.Iterator;

public class MicCapturaValor1Parcela {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String VALUE_NOT_VALID = "VALUE_NOT_VALID";
    public static final String VALUE_NOT_VALID_AC = "VALUE_NOT_VALID_AC";

    public String execute(ICapturaValorParcela dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!dados.getSaidaApiTef().isParcela()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        PlanoCDC planoCDC = null;
        if (!(dados.getTipoFinanciamento() instanceof PlanoCDC)) {
            throw new IllegalStateException("Financiamento n\u00e3o permite valor de pacela");
        }
        planoCDC = (PlanoCDC)dados.getTipoFinanciamento();
        if (planoCDC.getValorParcela() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isParcelasCtrl()) {
            Iterator parcelas = dados.getEntradaIntegracao().getParcelas().iterator();
            if (parcelas.hasNext()) {
                Parcela parcela = (Parcela)parcelas.next();
                if (!planoCDC.isValidaValorParcela(dados.getValorTransacao(), planoCDC.getValorParcela())) {
                    dados.setErroIntegracao(new CodigoErroIntegracao(5312, inter.getMessage("CAPVAL1PAR_VALOR_INVALIDO")));
                    return VALUE_NOT_VALID_AC;
                }
                planoCDC.setValorParcela(parcela.getValor());
            }
        } else {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("CAPVAL1PAR_ 1PARCELA")));
            displayModel.addLinha(new Linha(inter.getMessage("CAPVAL1PAR_VALOR")));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_1PARCELA, false, 8, false);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String digitos = eventoTeclado.getStringLida().substring(num);
            if (digitos.equals("")) {
                digitos = "000";
            }
            BigDecimal valor = new BigDecimal(digitos);
            valor = valor.movePointLeft(2);
            if (!planoCDC.isValidaValorParcela(dados.getValorTransacao(), valor)) {
                if (this.exibeMensagem(perifericos, inter.getMessage("CAPVAL1PAR_VALOR_INVALIDO")).equals("ENTRA")) {
                    return VALUE_NOT_VALID;
                }
                return USERCANCEL;
            }
            planoCDC.setValorParcela(valor);
        }
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

