/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IValorAcrescimo;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaValorAcrescimo {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IValorAcrescimo dados) throws ExcecaoApiAc {
        boolean capturaEncargos = true;
        BigDecimal valorAcrescimo = new BigDecimal(0);
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (dados.getSaidaApiTef() != null) {
            if (dados.getSaidaApiTef().getValorAcrescimo() != null) {
                valorAcrescimo = dados.getSaidaApiTef().getValorAcrescimo();
            }
            if (!dados.getSaidaApiTef().isCapturaAcrescimo()) {
                dados.setValorAcrescimo(valorAcrescimo);
                return UNECESSARY;
            }
            if (dados.getValorAcrescimo() != null) {
                return SUCCESS;
            }
        } else {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            if (!conf.isCapturaEncargosCCB()) {
                capturaEncargos = false;
            }
        }
        if (dados.getValorAcrescimo() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorAcrescimoCtrl()) {
            this.logger.log((Priority)Level.INFO, (Object)"Assumindo o acr\u00e9scimo informado pela AC");
            dados.setValorAcrescimo(dados.getEntradaIntegracao().getValorAcrescimo());
            return SUCCESS;
        }
        if (capturaEncargos) {
            return this.capturaValor(dados, valorAcrescimo, perifericos);
        }
        this.logger.log((Priority)Level.INFO, (Object)"CTFClient configurado para n\u00e3o capturar engargos para CCB");
        return UNECESSARY;
    }

    private String capturaValor(IValorAcrescimo dados, BigDecimal valorDefault, ControladorPerifericos perifericos) throws ExcecaoApiAc {
        DecimalFormat decimalFormat = new DecimalFormat("#");
        valorDefault = valorDefault.multiply(new BigDecimal(100));
        String valor = decimalFormat.format(valorDefault);
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPVALACR_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_ACRESCIMO, valor, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valorAcrescimo = new BigDecimal(digitos);
        valorAcrescimo = valorAcrescimo.movePointLeft(2);
        dados.setValorAcrescimo(valorAcrescimo);
        return SUCCESS;
    }
}

