/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaValorCancelamento;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicCapturaValorCancelamento {
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String VERIFICAR_FINANCIAMENTO = "VERIFICAR_FINANCIAMENTO";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String OPERATION_NOT_ALLOWAD = "OPERATION_NOT_ALLOWAD";

    public String execute(ICapturaValorCancelamento dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean cancelamentoParcial = dados.getSaidaApiTef().isCancelamentoParcial();
        if (!cancelamentoParcial) {
            if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorCancelamentoCtrl()) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5388, "CANCELAMENTO INVALIDO"));
                return OPERATION_NOT_ALLOWAD;
            }
            dados.setValorCancelamento(dados.getValorTransacao());
            if (dados.isTransacaoSemLog()) {
                return VERIFICAR_FINANCIAMENTO;
            }
            return UNECESSARY;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                dados.setValorCancelamento(dados.getEntradaIntegracao().getValorTransacao());
                return UNECESSARY;
            }
            if (dados.getEntradaIntegracao().isValorCancelamentoCtrl()) {
                dados.setValorCancelamento(dados.getEntradaIntegracao().getValorCancelamento());
                return UNECESSARY;
            }
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("CAPVALCAN_TITLE")));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_CANCELAMENTO, true, 12, true);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String digitos = eventoTeclado.getStringLida().substring(num);
            if (digitos.equals("")) {
                return INVALID_NUMBER;
            }
            BigDecimal valor = new BigDecimal(digitos);
            if (valor.equals(new BigDecimal(0))) {
                return INVALID_NUMBER;
            }
            valor = valor.movePointLeft(2);
            dados.setValorCancelamento(valor);
        } else if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        return SUCESS;
    }
}

