/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaValorCreditoDigital;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ConsultaValoresCreditoDigital;
import com.csi.ctfclient.operacoes.model.ValorRecargaTelefone;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaValorCreditoDigital {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR_AC = "ERROR_AC";
    private static Logger logger = CTFClientLogger.getCTFClient();
    private static final String MSG_ERRO_FALTAM_VALORES_FIXOS = "N\u00c3O EXISTEM VALORES DE RECARGA A SEREM EXIBIDOS";

    public String execute(ICapturaValorCreditoDigital dados) throws ExcecaoApiAc {
        LayoutMenu layoutMenu;
        if (dados.getValorTransacao() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isValorTransacaoCtrl()) {
                dados.setValorTransacao(dados.getEntradaIntegracao().getValorTransacao());
                return SUCESS;
            }
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5300, "VALOR NAO INFORMADO"));
                return ERROR_AC;
            }
        }
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ConsultaValoresCreditoDigital valoresCD = dados.getConsultaValoresCreditoDigital();
        String[] titulo = new String[]{inter.getMessage("CAPVALCREDIG_OPERADORA") + " " + dados.getOperadoraTelefonia().getNome(), inter.getMessage("CAPVALCREDIG_VALORES")};
        List listValores = valoresCD.getValores();
        boolean existemValoresFixos = listValores != null && listValores.size() > 0;
        String complementoDisplay = "";
        if (config.isPermiteValoresVariaveis()) {
            layoutMenu = new LayoutMenu(titulo, false);
            complementoDisplay = "  ";
        } else {
            layoutMenu = new LayoutMenu(titulo, true);
        }
        DecimalFormat format = new DecimalFormat("#,##0.00");
        Iterator iteList = null;
        if (listValores != null) {
            iteList = listValores.iterator();
        }
        int indiceMenu = 1;
        while (existemValoresFixos && iteList.hasNext()) {
            ValorRecargaTelefone valorRecarga = (ValorRecargaTelefone)iteList.next();
            if (valorRecarga.getValor().compareTo(new BigDecimal(0)) == 0) continue;
            String text = complementoDisplay + inter.getMessage("CAPVALCREDIG_VALOR") + format.format(valorRecarga.getValor()) + " " + inter.getMessage("CAPVALCREDIG_BONUS") + format.format(valorRecarga.getBonus());
            if (config.isPermiteValoresVariaveis()) {
                layoutMenu.addItem(new ItemMenu(text, 2));
                continue;
            }
            layoutMenu.addItem(new ItemMenu(text, String.valueOf(indiceMenu)));
            ++indiceMenu;
        }
        ArrayList<String> mensagemCaptura = new ArrayList<String>();
        if (config.isPermiteValoresVariaveis()) {
            BigDecimal valorMinimoVar = dados.getConsultaValoresCreditoDigital().getValorVariavelMinimo();
            BigDecimal valorMaximoVar = dados.getConsultaValoresCreditoDigital().getValorVariavelMaximo();
            if (valorMinimoVar.compareTo(new BigDecimal(0)) != 0 || valorMaximoVar.compareTo(new BigDecimal(0)) != 0) {
                if (existemValoresFixos) {
                    mensagemCaptura.add(inter.getMessage("CAPVALCREDIG_VALORES_VARIAVEIS"));
                }
                String text = "  " + inter.getMessage("CAPVALCREDIG_VALOR") + format.format(valorMinimoVar) + " " + inter.getMessage("CAPVALCREDIG_ATE") + format.format(valorMaximoVar);
                mensagemCaptura.add(text);
                if (!existemValoresFixos) {
                    mensagemCaptura.add(" ");
                }
            }
        }
        BigDecimal valor = null;
        mensagemCaptura.add(inter.getMessage("CAPVALCREDIG_VALOR_COMPRA"));
        boolean valorValido = false;
        while (!valorValido) {
            if (config.isPermiteValoresVariaveis()) {
                EventoTeclado eventoTeclado = periferico.imprimeMenu(layoutMenu, this.converteArrayString(mensagemCaptura.toArray()), ConstantesApiAc.CAP_CREDITO_DIGITAL);
                if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                    int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                    String digitos = eventoTeclado.getStringLida().substring(num);
                    if (digitos.equals("")) {
                        digitos = "000";
                    }
                    valor = new BigDecimal(digitos);
                    if (!this.validaValorCompra(valor = valor.movePointLeft(2), valoresCD)) continue;
                    valorValido = true;
                    continue;
                }
                if (!eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) continue;
                return USER_CANCEL;
            }
            if (layoutMenu.getItens().size() > 0) {
                int opcao = periferico.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    return USER_CANCEL;
                }
                valor = ((ValorRecargaTelefone)listValores.get(opcao - 1)).getValor();
                valorValido = true;
                continue;
            }
            logger.log((Priority)Level.ERROR, (Object)"A integra\u00e7\u00e3o com a automa\u00e7\u00e3o permite apenas exibi\u00e7\u00e3o de valores de recarga fixos e n\u00e3o foi retornado nenhum pela autorizadora.");
            dados.setErroIntegracao(new CodigoErroIntegracao(5387, MSG_ERRO_FALTAM_VALORES_FIXOS));
            return ERROR_AC;
        }
        dados.setValorTransacao(valor);
        return SUCESS;
    }

    private boolean validaValorCompra(BigDecimal valorCompra, ConsultaValoresCreditoDigital valoresCD) {
        boolean retorno = false;
        Iterator iteValores = null;
        if (valoresCD.getValores() != null) {
            iteValores = valoresCD.getValores().iterator();
        }
        BigDecimal valorMinimoVar = valoresCD.getValorVariavelMinimo();
        BigDecimal valorMaximoVar = valoresCD.getValorVariavelMaximo();
        while (iteValores != null && iteValores.hasNext()) {
            ValorRecargaTelefone valorRecarga = (ValorRecargaTelefone)iteValores.next();
            if (valorRecarga.getValor().compareTo(valorCompra) != 0) continue;
            retorno = true;
            break;
        }
        if (!(retorno || valorMinimoVar.compareTo(new BigDecimal(0)) == 0 && valorMaximoVar.compareTo(new BigDecimal(0)) == 0 || (valorMinimoVar.compareTo(valorCompra) != -1 || valorMaximoVar.compareTo(valorCompra) != 1) && valorMinimoVar.compareTo(valorCompra) != 0 && valorMaximoVar.compareTo(valorCompra) != 0)) {
            retorno = true;
        }
        return retorno;
    }

    private String[] converteArrayString(Object[] arrayObject) {
        String[] arrayString = new String[arrayObject.length];
        for (int i = 0; i < arrayObject.length; ++i) {
            arrayString[i] = arrayObject[i].toString();
        }
        return arrayString;
    }
}

