/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IValorDesconto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaValorDesconto {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Logger logger = CTFClientLogger.getCTFClient();
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(IValorDesconto dados) throws ExcecaoApiAc {
        ControladorPerifericos perifericos = dados.getPerifericos();
        BigDecimal valorDesconto = new BigDecimal(0);
        boolean capturaEncargos = true;
        if (dados.getSaidaApiTef() != null) {
            if (dados.getSaidaApiTef().getValorDesconto() != null) {
                valorDesconto = dados.getSaidaApiTef().getValorDesconto();
            }
            if (!dados.getSaidaApiTef().isCapturaDesconto()) {
                dados.setValorDesconto(valorDesconto);
                return UNECESSARY;
            }
            if (dados.getValorDesconto() != null) {
                return SUCCESS;
            }
        } else {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            if (!conf.isCapturaEncargosCCB()) {
                capturaEncargos = false;
            }
        }
        if (dados.getValorDesconto() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorDescontoCtrl()) {
            this.logger.log((Priority)Level.INFO, (Object)"Assumindo o acr\u00e9scimo informado pela AC");
            dados.setValorDesconto(dados.getEntradaIntegracao().getValorDesconto());
            return SUCCESS;
        }
        if (capturaEncargos) {
            return this.capturaValor(dados, valorDesconto, perifericos);
        }
        this.logger.log((Priority)Level.INFO, (Object)"CTFClient configurado para n\u00e3o capturar engargos para CCB");
        return UNECESSARY;
    }

    private String capturaValor(IValorDesconto dados, BigDecimal valorDefault, ControladorPerifericos perifericos) throws ExcecaoApiAc {
        DecimalFormat decimalFormat = new DecimalFormat("#");
        valorDefault = valorDefault.multiply(new BigDecimal(100));
        String valor = decimalFormat.format(valorDefault);
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPVALDES_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_DESCONTO, valor, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valorDesconto = new BigDecimal(digitos);
        valorDesconto = valorDesconto.movePointLeft(2);
        dados.setValorDesconto(valorDesconto);
        return SUCCESS;
    }

    public static void main(String[] args) {
        BigDecimal bValor = new BigDecimal("12.00");
        System.out.println(bValor);
        DecimalFormat decimalFormat = new DecimalFormat("#");
        bValor = bValor.multiply(new BigDecimal(100));
        System.out.println(bValor);
        System.out.println(decimalFormat.format(bValor));
    }
}

