/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IValorDocumentoCorBan;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicCapturaValorDocumentoCorBan {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String CONFIRM_VALUE = "CONFIRM_VALUE";
    public static final String INVALID_CONFIRMATION = "INVALID_CONFIRMATION";
    public static final String INVALID_CONFIRMATION_AC = "INVALID_CONFIRMATION_AC";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(IValorDocumentoCorBan dados) throws ExcecaoNaoLocal {
        BigDecimal valor;
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (dados.getValorDocumento() != null && !dados.isConfirmacaoValorDocumento() || dados.getValorDocumento() != null && dados.isNaoConfirmaValorDocumento()) {
            return FILLED;
        }
        BigDecimal valorTransacaoIntegracao = null;
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isValorTransacaoCtrl()) {
                if (dados.getValorDocumento() != null) {
                    if (dados.getEntradaIntegracao().getValorTransacao().compareTo(dados.getValorDocumento()) == 0) {
                        return SUCESS;
                    }
                    dados.setErroIntegracao(new CodigoErroIntegracao(5319, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION")));
                    return INVALID_CONFIRMATION_AC;
                }
                dados.setValorDocumento(dados.getEntradaIntegracao().getValorTransacao());
            }
        } else {
            valorTransacaoIntegracao = dados.getValorTransacao();
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorTransacaoCtrl()) {
            if (dados.getEntradaIntegracao().getValorTransacao().equals(dados.getValorDocumento())) {
                return SUCESS;
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5319, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION")));
            return INVALID_CONFIRMATION_AC;
        }
        if (dados.getSaidaApiTef() != null && dados.getSaidaApiTef().isExigeConfirmacaoValorDocumento()) {
            BigDecimal valor2 = null;
            if (valorTransacaoIntegracao != null && dados.isConfirmacaoValorDocumento()) {
                valor2 = valorTransacaoIntegracao;
            } else {
                try {
                    valor2 = this.solicitaValorUsuario(perifericos);
                }
                catch (UserCancelException e) {
                    return USER_CANCEL;
                }
                catch (invalidNumberException e) {
                    return INVALID_NUMBER;
                }
            }
            if (!dados.isConfirmacaoValorDocumento()) {
                dados.setValorDocumento(valor2);
                dados.setConfirmacaoValorDocumento(true);
                return CONFIRM_VALUE;
            }
            if (valor2.equals(dados.getValorDocumento())) {
                return SUCESS;
            }
            if (valorTransacaoIntegracao != null) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5319, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION")));
                return INVALID_CONFIRMATION_AC;
            }
            EventoTeclado eventoTeclado = (EventoTeclado)this.exibeMensagem(perifericos, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION"));
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            if (!dados.isValorDocumentoLido()) {
                dados.setValorDocumento(null);
                dados.setConfirmacaoValorDocumento(false);
            }
            return INVALID_CONFIRMATION;
        }
        if (dados.getValorDocumento() != null) {
            if (valorTransacaoIntegracao != null && !valorTransacaoIntegracao.equals(dados.getValorDocumento())) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5319, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION")));
                return INVALID_CONFIRMATION_AC;
            }
            DecimalFormat format = new DecimalFormat("#,##0.00");
            EventoTeclado eventoTeclado = (EventoTeclado)this.exibeMensagem(perifericos, this.inter.getMessage("CAPVALDOC_DOC_VALUE") + " " + format.format(dados.getValorDocumento()));
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            dados.setValorTransacao(dados.getValorDocumento());
            return SUCESS;
        }
        if (valorTransacaoIntegracao != null) {
            valor = valorTransacaoIntegracao;
        } else {
            try {
                valor = this.solicitaValorUsuario(perifericos);
            }
            catch (UserCancelException e) {
                return USER_CANCEL;
            }
            catch (invalidNumberException e) {
                return INVALID_NUMBER;
            }
        }
        dados.setValorDocumento(valor);
        dados.setValorTransacao(valor);
        return SUCESS;
    }

    private BigDecimal solicitaValorUsuario(ControladorPerifericos perifericos) throws ExcecaoNaoLocal, UserCancelException, invalidNumberException {
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPVALDOC_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_DOCUMENTO, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            throw new UserCancelException();
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            throw new invalidNumberException();
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (valor.equals(new BigDecimal(0))) {
            throw new invalidNumberException();
        }
        valor = valor.movePointLeft(2);
        return valor;
    }

    private EventoDispositivoEntrada exibeMensagem(ControladorPerifericos perifericos, String mensagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(mensagem);
        return perifericos.confirmaDado(displayModel);
    }

    class invalidNumberException
    extends Exception {
        private static final long serialVersionUID = 2L;

        invalidNumberException() {
        }
    }
}

