/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaValorEntrada;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaValorEntrada {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String VALUE_NOT_VALID = "VALUE_NOT_VALID";
    public static final String VALUE_NOT_VALID_AC = "VALUE_NOT_VALID_AC";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ICapturaValorEntrada dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!dados.getSaidaApiTef().isEntrada()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        PlanoCDC planoCDC = null;
        if (!(dados.getTipoFinanciamento() instanceof PlanoCDC)) {
            this.logger.log((Priority)Level.WARN, (Object)"CTF indicou a captura do valor de entrada, por\u00e9m o tipo de financiamento n\u00e3o permite valor de entrada.");
            return UNECESSARY;
        }
        planoCDC = (PlanoCDC)dados.getTipoFinanciamento();
        if (planoCDC.getValorEntrada() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorEntradaCtrl()) {
            if (!planoCDC.isValidaValorEntrada(dados.getValorTransacao(), dados.getEntradaIntegracao().getValorEntrada())) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5311, inter.getMessage("CAPVALENT_VALOR_INVALIDO1") + " " + inter.getMessage("CAPVALENT_VALOR_INVALIDO2")));
                return VALUE_NOT_VALID_AC;
            }
            planoCDC.setValorEntrada(dados.getEntradaIntegracao().getValorEntrada());
        } else {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("CAPVALENT_ENTRADA")));
            displayModel.addLinha(new Linha(inter.getMessage("CAPVALENT_VALOR")));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_ENTRADA, false, 8, false);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String digitos = eventoTeclado.getStringLida().substring(num);
            if (digitos.equals("")) {
                digitos = "000";
            }
            BigDecimal valor = new BigDecimal(digitos);
            valor = valor.movePointLeft(2);
            if (!planoCDC.isValidaValorEntrada(dados.getValorTransacao(), valor)) {
                if (this.exibeMensagem(perifericos, inter.getMessage("CAPVALENT_VALOR_INVALIDO1"), inter.getMessage("CAPVALENT_VALOR_INVALIDO2")).equals("ENTRA")) {
                    return VALUE_NOT_VALID;
                }
                return USERCANCEL;
            }
            planoCDC.setValorEntrada(valor);
        }
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String msg1, String msg2) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

