/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaValorEntrada;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.IPlanoComEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCapturaValorEntradaIATA {
    public static final String FILLED = "FILLED";
    public static final String SUCCESS = "SUCCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String VALUE_NOT_VALID = "VALUE_NOT_VALID";
    public static final String VALUE_NOT_VALID_AC = "VALUE_NOT_VALID_AC";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(ICapturaValorEntrada dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!dados.getSaidaApiTef().isEntrada()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        IPlanoComEntrada plano = null;
        if (!(dados.getTipoFinanciamento() instanceof IPlanoComEntrada)) {
            this.logger.log((Priority)Level.WARN, (Object)"CTF indicou a captura do valor de entrada, por\u00e9m o tipo de financiamento n\u00e3o permite valor de entrada.");
            return UNECESSARY;
        }
        plano = (IPlanoComEntrada)((Object)dados.getTipoFinanciamento());
        if (plano.getValorEntrada() != null) {
            return FILLED;
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isValorEntradaCtrl()) {
            if (!plano.isValidaValorEntrada(dados.getValorTransacao(), dados.getEntradaIntegracao().getValorEntrada())) {
                dados.setErroIntegracao(new CodigoErroIntegracao(5311, inter.getMessage("CAPVALENT_VALOR_INVALIDO1") + " " + inter.getMessage("CAPVALENT_VALOR_INVALIDO2")));
                return VALUE_NOT_VALID_AC;
            }
            plano.setValorEntrada(dados.getEntradaIntegracao().getValorEntrada());
        } else {
            LayoutDisplay layoutDisplay = new LayoutDisplay();
            layoutDisplay.addLinha(new Linha(inter.getMessage("CAPVALENT_ENTRADA")));
            layoutDisplay.addLinha(new Linha(inter.getMessage("CAPVALENT_VALOR")));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_VALOR_ENTRADA, false, 8, false);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String digitos = eventoTeclado.getStringLida().substring(num);
            if (digitos.equals("")) {
                digitos = "000";
            }
            BigDecimal valor = new BigDecimal(digitos);
            valor = valor.movePointLeft(2);
            if (!plano.isValidaValorEntrada(dados.getValorTransacao(), valor)) {
                if (this.exibeMensagem(perifericos, inter.getMessage("CAPVALENT_VALOR_INVALIDO1"), inter.getMessage("CAPVALENT_VALOR_INVALIDO2")).equals("ENTRA")) {
                    return VALUE_NOT_VALID;
                }
                return USERCANCEL;
            }
            plano.setValorEntrada(valor);
        }
        return SUCCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String msg1, String msg2) throws ExcecaoNaoLocal {
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha(msg1));
        layoutDisplay.addLinha(new Linha(msg2));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(layoutDisplay);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

