/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICapturaValorParcela;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.IPlanoValorParcela;
import com.csi.ctfclient.operacoes.model.Parcela;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.util.Collection;

public class MicCapturaValorParcela {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String VALUE_NOT_VALID = "VALUE_NOT_VALID";
    public static final String VALUE_NOT_VALID_AC = "VALUE_NOT_VALID_AC";

    public String execute(ICapturaValorParcela dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!dados.getSaidaApiTef().isParcela()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        IPlanoValorParcela planoParcela = null;
        if (!(dados.getTipoFinanciamento() instanceof IPlanoValorParcela)) {
            throw new IllegalStateException("Financiamento n\u00e3o permite valor de pacela");
        }
        planoParcela = (IPlanoValorParcela)((Object)dados.getTipoFinanciamento());
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isParcelasCtrl()) {
            Collection parcelas = dados.getEntradaIntegracao().getParcelas();
            if (parcelas != null && !parcelas.isEmpty()) {
                Parcela parcela = (Parcela)parcelas.iterator().next();
                if (planoParcela.isValidaValorParcela(dados.getValorTransacao(), parcela.getValor())) {
                    planoParcela.setValorParcela(dados.getEntradaIntegracao().getValorParcela());
                    return SUCESS;
                }
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5312, inter.getMessage("CAPVALPAR_VALOR_INVALIDO")));
            return VALUE_NOT_VALID_AC;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPVALPAR_VALOR_ENTRADA"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_PARCELA, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valor = new BigDecimal(digitos);
        valor = valor.movePointLeft(2);
        if (!planoParcela.isValidaValorParcela(dados.getValorTransacao(), valor)) {
            if (this.exibeMensagem(perifericos, inter.getMessage("CAPVALPAR_VALOR_INVALIDO")).equals("ENTRA")) {
                return VALUE_NOT_VALID;
            }
            return USERCANCEL;
        }
        planoParcela.setValorParcela(valor);
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

