/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICargaTabelasPinpad;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDs;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicCargaTabelaPinpad
implements ConstantesEMV {
    private static Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";

    public int numRegistros(String registros) {
        int tam = 0;
        int numRegistros = 0;
        if (registros == null) {
            return 0;
        }
        while (tam < registros.length()) {
            String strTam = registros.substring(tam, tam + 3);
            int offset = Integer.parseInt(strTam);
            tam = offset == 0 ? (tam += 3) : (tam += offset);
            ++numRegistros;
        }
        return numRegistros;
    }

    public String execute(ICargaTabelasPinpad dados) throws ExcecaoApiAc {
        try {
            String[] tabela = dados.getConteudoTabelas().toArray(new String[0]);
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            ILeitorCartaoHandler leitorCartao = perifericos.getLeitorCartao();
            CMOSPinPad cmos = CMOSPinPad.getInstance();
            SaidaApiTefC saida = dados.getSaidaApiTef();
            int redeAdquirente = saida != null && saida.getTipoBibliotecaPinpad() == 2 ? saida.getTipoBibliotecaPinpad() : 0;
            String timeStamp = cmos.getTimeStamp(redeAdquirente);
            boolean informaAIDGetCard = saida.isInformaAIDGetcard();
            ControladorAIDs controladorAIDs = new ControladorAIDs();
            DecimalFormat format2Zeros = new DecimalFormat("00");
            int retry = 0;
            boolean ocorreuErro = false;
            do {
                int indice = 1;
                int retorno = leitorCartao.iniciaCargaTabelas(timeStamp);
                if (retorno == 20 || retorno == 0) {
                    for (int i = 0; !ocorreuErro && i < tabela.length; ++i) {
                        int numRegistros = this.numRegistros(tabela[i]);
                        if (numRegistros == 0) continue;
                        logger.log((Priority)Level.DEBUG, (Object)("Dados tabela: 01" + tabela[i]));
                        if (informaAIDGetCard) {
                            controladorAIDs.addLinhaCargaTabelas(tabela[i]);
                        }
                        perifericos.imprimeDisplay(new LayoutDisplay(inter.getMessage("ENV2M_ATUALIZANDO") + " (" + format2Zeros.format(indice) + "/" + tabela.length + ")"));
                        ++indice;
                        ocorreuErro = leitorCartao.executaCargaTabelas("01" + tabela[i]) != 0;
                    }
                    ocorreuErro = leitorCartao.finalizaCargaTabelas() != 0;
                    continue;
                }
                ocorreuErro = true;
            } while (++retry <= 3 && ocorreuErro);
            if (!ocorreuErro) {
                cmos.habilitaCargaTabelas(redeAdquirente);
                if (informaAIDGetCard) {
                    logger.info((Object)"Persistindo AIDs que ser\u00e3o utilizados na GetCard...");
                    try {
                        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
                        IdentTerminal identTerminal = new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                        ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal, config.getVersaoPathTerminal());
                        controladorAIDsGetCard.saveMapAid(controladorAIDs.getMapAIDs());
                        leitorCartao.setSolicitaCargaTabelas(LeitorCartaoEMV.CARGA_TABELA_OK);
                        logger.info((Object)"AIDs persistidos com sucesso");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.warn((Object)"Problema ao persistir os AIDs para leitura na GetCard");
                    }
                } else {
                    try {
                        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
                        IdentTerminal identTerminal = new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                        ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal, config.getVersaoPathTerminal());
                        if (controladorAIDsGetCard.getMapAid() != null) {
                            logger.info((Object)"Limpando AIDs que ser\u00e3o utilizados na GetCard...");
                            controladorAIDsGetCard.saveMapAid(null);
                            logger.info((Object)"Limpeza de AIDs completa");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.warn((Object)"Problema ao limpar os AIDs para leitura na GetCard");
                    }
                }
                logger.log((Priority)Level.INFO, (Object)"******************************************************************");
                logger.log((Priority)Level.INFO, (Object)"******** CARGA DE TABELA NO PIN EFETUADA COM SUCESSO *************");
                logger.log((Priority)Level.INFO, (Object)"******************************************************************");
            } else {
                logger.log((Priority)Level.ERROR, (Object)"******************************************************************");
                logger.log((Priority)Level.ERROR, (Object)"*************** ERRO NA CARGA DE TABELA NO PIN *******************");
                logger.log((Priority)Level.ERROR, (Object)"******************************************************************");
            }
            return SUCESS;
        }
        catch (Exception e) {
            return ERRO;
        }
    }
}

