/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IConfiguraPinpad;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ControladorDetectaPinpad;

public class MicConfiguraPinpad {
    public static final String CONFIG_OK = "CONFIG_OK";
    public static final String ERRO = "ERRO";

    public String execute(IConfiguraPinpad dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.setDelay(4000L);
        layoutDisplay.addLinha(new Linha("A COMUNICACAO COM O PINPAD FALHOU"));
        layoutDisplay.addLinha(new Linha("A CONFIGURACAO AUTOMATICA", 0, 1));
        layoutDisplay.addLinha(new Linha("SERA INICIALIZADA."));
        layoutDisplay.addLinha(new Linha("POR FAVOR AGUARDE...", 0, 1));
        perifericos.imprimeDisplay(layoutDisplay);
        String portaSerial = ControladorDetectaPinpad.getInstancia().detectaPinpad(perifericos);
        if (portaSerial != null) {
            ControladorConfCTFClient.getInstance().configuraPinpad(portaSerial);
            dados.setErroIntegracao(null);
            return CONFIG_OK;
        }
        layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha("NAO FOI POSSIVEL CONFIGURAR"));
        layoutDisplay.addLinha(new Linha("O PINPAD."));
        layoutDisplay.addLinha(new Linha("POR FAVOR VERIFIQUE SE O MESMO", 0, 1));
        layoutDisplay.addLinha(new Linha("ESTA DEVIDAMENTE CONECTADO."));
        layoutDisplay.addLinha(new Linha("[ENTER] PARA CONTINUAR...", 0, 1));
        perifericos.confirmaDado(layoutDisplay);
        return ERRO;
    }
}

