/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IConfirmacaoOperacao;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.operacoes.model.InformacoesAdicionais;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MicConfirmaOperacao {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IConfirmacaoOperacao dado) throws ExcecaoApiAc {
        boolean multiTerminal = false;
        boolean delivery = false;
        if (dado.getEntradaIntegracao() != null) {
            multiTerminal = dado.getEntradaIntegracao().isMultiTerminal();
            delivery = dado.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            delivery = dado.getCodigoOrigemTransacao() == 1;
        }
        EntradaApiTefC entradaApiTefC = null;
        String key = String.valueOf(dado.getEntradaIntegracao().getNumeroTransacao());
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal || delivery ? (dado.getEntradaIntegracao() != null ? dado.getEntradaIntegracao().getIdentTerminal() : dado.getIdentTerminal()) : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entradaApiTefC = new EntradaApiTefC();
        DadosConfirmacaoDesfazimento entrada = null;
        try {
            entrada = (DadosConfirmacaoDesfazimento)PersistService.getInstance().load(key, identTerminal, conf.getVersaoPathTerminal());
            if (entrada.isModoVendaRemota() && (entrada.getModoIntegracaoPOSTef() == 2 || entrada.getModoIntegracaoPOSTef() == 3)) {
                this.logger.info((Object)"transacao executa em modo POSTef com confirmacao no POS habilitada.");
                SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
                saidaApiTefC.setRetorno(0);
                saidaApiTefC.setCodigoErro(0);
                dado.setSaidaApiTef(saidaApiTefC);
                return SUCESS;
            }
            entradaApiTefC.setNumeroTransacao(entrada.getNumeroTransacao());
            entradaApiTefC.setDataCliente(entrada.getDataCliente());
            entradaApiTefC.setNumeroSeriePin(entrada.getNumeroSeriePin());
            entradaApiTefC.setTimeoutCtf(entrada.getTimeout());
            entradaApiTefC.setTimestamp(entrada.getTimestamp());
            entradaApiTefC.setDadosFinaisChip(entrada.getDadosFinaisChip());
            entradaApiTefC.setIssuerScriptResult(entrada.getIssuerScriptResult());
        }
        catch (ExcecaoApiAc e) {
            this.logger.error((Object)("n\u00e3o foi poss\u00edvel recuperar os dados da transa\u00e7\u00e3o para realizar a confirma\u00e7\u00e3o no terminal " + identTerminal), (Throwable)e);
        }
        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().isMadCtrl()) {
            entradaApiTefC.setInformacoesAdicionais(this.formataInformacoesAdicionaisMad(dado.getEntradaIntegracao().getMad()));
        }
        SaidaApiTefC saida = dado.getApitef().confirmacao(ident, entradaApiTefC);
        dado.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0 && saida.getRetorno() != 10 && saida.getRetorno() != 13) {
            this.logger.error((Object)("n\u00e3o foi poss\u00edvel confirmar a transa\u00e7\u00e3o " + key + " para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf."));
            return FAIL;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("confirma\u00e7\u00e3o da transa\u00e7\u00e3o " + entrada.getNumeroTransacao() + " para o terminal " + identTerminal + " realizada com sucesso."));
        }
        if (saida.getRetorno() == 10) {
            this.logger.warn((Object)"apitef retornou erro de comunicacao, porem, a transacao esta confirmada no ctfclient e sera sincronizada na proxima transacao.");
            this.logger.warn((Object)("retorno: 10, cod_erro: " + saida.getCodigoErro() + ", alterado para retorno: 0, cod_erro: 0000"));
            saida.setRetorno(0);
            saida.setCodigoErro(0);
        }
        return SUCESS;
    }

    private List formataInformacoesAdicionaisMad(String mad) {
        ArrayList<InformacoesAdicionais> listInformacoesAdicionais = new ArrayList<InformacoesAdicionais>();
        listInformacoesAdicionais.add(new InformacoesAdicionais("01", "01", "01", 1, 39, true, false, 0, null, mad.length(), mad, "1", 0));
        return listInformacoesAdicionais;
    }
}

