/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IConfirmacaoOperacao;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public class MicConfirmaOperacaoPreVenda {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IConfirmacaoOperacao dados) throws ExcecaoApiAc {
        String key = "";
        if (dados.getEntradaIntegracao() == null) {
            dados.setErroIntegracao(new CodigoErroIntegracao(5303, "NUMERO TRANS INVALIDO"));
            return ERROR_AC;
        }
        key = String.valueOf(dados.getEntradaIntegracao().getNumeroTransacao());
        EntradaApiTefC entrada = null;
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada = new EntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao());
        DadosConfirmacaoDesfazimento entradaPersistida = null;
        try {
            entradaPersistida = (DadosConfirmacaoDesfazimento)PersistService.getInstance().load(key, identTerminal, conf.getVersaoPathTerminal());
            entrada.setNumeroTransacao(entradaPersistida.getNumeroTransacao());
            entrada.setDataCliente(entradaPersistida.getDataCliente());
            entrada.setNumeroSeriePin(entradaPersistida.getNumeroSeriePin());
            entrada.setTimeoutCtf(entradaPersistida.getTimeout());
            entrada.setTimestamp(entradaPersistida.getTimestamp());
            entrada.setDadosFinaisChip(entradaPersistida.getDadosFinaisChip());
            entrada.setIssuerScriptResult(entradaPersistida.getIssuerScriptResult());
        }
        catch (ExcecaoApiAc e) {
            this.logger.error((Object)("n\u00e3o foi poss\u00edvel recuperar os dados da transa\u00e7\u00e3o para realizar a confirma\u00e7\u00e3o no terminal " + identTerminal), (Throwable)e);
        }
        SaidaApiTefC saida = dados.getApitef().confirmacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0 && saida.getRetorno() != 10 && saida.getRetorno() != 13) {
            this.logger.error((Object)("n\u00e3o foi poss\u00edvel confirmar a pr\u00e9-venda da transa\u00e7\u00e3o " + key + " para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf."));
            return ERROR;
        }
        String numeroTransacaoString = entradaPersistida != null ? String.valueOf(entradaPersistida.getNumeroTransacao()) : "<null>";
        this.logger.debug((Object)("confirma\u00e7\u00e3o da transa\u00e7\u00e3o de pr\u00e9-venda " + numeroTransacaoString + " para o terminal " + identTerminal + " realizada com sucesso."));
        if (saida.getRetorno() == 10) {
            this.logger.warn((Object)"apitef retornou erro de comunicacao, porem, a transacao esta confirmada no ctfclient e sera sincronizada na proxima transacao.");
            this.logger.warn((Object)("retorno: 10, cod_erro: " + saida.getCodigoErro() + ", alterado para retorno: 0, cod_erro: 0000"));
            saida.setRetorno(0);
            saida.setCodigoErro(0);
        }
        return SUCCESS;
    }

    protected String getCodigoTransacao() throws IllegalStateException {
        return "90";
    }
}

