/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.entrada.IConfirmacaoResgatePremio;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.Premio;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicConfirmacaoResgatePremio {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(IConfirmacaoResgatePremio dados) throws ExcecaoPerifericos {
        ControladorPerifericos periferico = dados.getPerifericos();
        PinEMV pin = periferico.getPin();
        String retorno = this.confirmaTelefone(dados, pin);
        return retorno;
    }

    private String confirmaTelefone(IConfirmacaoResgatePremio dados, PinEMV pin) throws ExcecaoPerifericos {
        Criptografia criptografia = null;
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Premio premio = dados.getPremio();
        String mensagemPin = premio.getDescricao().length() > 16 ? premio.getDescricao().substring(0, 16) : StringUtil.completaString(premio.getDescricao(), 16, ' ', 4);
        mensagemPin = mensagemPin + "RESGATAR?   " + StringUtil.completaString(String.valueOf(dados.getNumeroPremios()), 4, ' ', 3);
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(null, criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(this.inter.getMessage("CONRESPRE_TITLE_TELA"));
        dados.getPerifericos().getPin().setMsgDisplay(mensagemPin);
        processLeituraPin.setTipoLeituraPin(3);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (processLeituraPin.getState() == 3) {
                dados.setNumeroPremios(0);
                return USER_CANCEL;
            }
            if (processLeituraPin.getState() == 5) {
                dados.setNumeroPremios(0);
                return USER_CANCEL_INTERNAL;
            }
            if (processLeituraPin.getState() == 1) {
                return ERROR;
            }
            if (processLeituraPin.getTeclaFuncaoPressionada() == 0) {
                return SUCCESS;
            }
            return USER_CANCEL;
        }
        catch (Exception e) {
            return ERROR;
        }
    }
}

