/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessConsultaFinanciamentoCredito;
import com.csi.ctfclient.operacoes.entrada.IConsultaFinanciamento;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.TaxaJuroParcela;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicConsultaFinanciamento {
    private Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";

    public String execute(IConsultaFinanciamento dados) {
        if (dados.getSaidaApiTef() != null && dados.getSaidaApiTef().isConsultaFinanciamento()) {
            if (!(dados.getPlano() instanceof PlanoAPrazo)) {
                this.logger.warn((Object)"consulta disponivel apenas para plano a prazo");
                return UNECESSARY;
            }
            ProcessManager processManager = ProcessManager.getInstance();
            ProcessConsultaFinanciamentoCredito process = new ProcessConsultaFinanciamentoCredito(dados.getEntradaIntegracao(), dados.getValorTransacao(), dados.getCartao(), dados.getPlano());
            try {
                processManager.subProcess(dados.getIdProcess(), process);
                if ((process.getState() == 0 || process.getState() == 2) && process.getSaidaApiTef() != null && process.getSaidaApiTef().getRetorno() == 0) {
                    List parcelas = process.getConsultaParcelas();
                    if (parcelas != null && parcelas.size() > 0) {
                        TaxaJuroParcela parcela = (TaxaJuroParcela)parcelas.iterator().next();
                        DecimalFormat formatNumber = new DecimalFormat("#,##0.00");
                        String parcelaFormatada = StringUtil.completaString(parcela.getNumero() + "", 2, '0', 3);
                        LayoutDisplay display = new LayoutDisplay();
                        display.addLinha(new Linha("CONFIRME OS DADOS DO FINANCIAMENTO"));
                        display.addLinha(new Linha("QTDE PARCELAS: " + parcelaFormatada, 0, 1));
                        display.addLinha(new Linha("VALOR PARCELA: " + formatNumber.format(parcela.getValor())));
                        display.addLinha(new Linha("TAXA JUROS: " + formatNumber.format(parcela.getTaxaJuros())));
                        display.addLinha(new Linha("VALOR TOTAL: " + formatNumber.format(parcela.getValorTotal())));
                        ControladorPerifericos perifericos = dados.getPerifericos();
                        perifericos.confirmaDado(display);
                    }
                    return SUCESS;
                }
                if (process.getState() == 3) {
                    return USERCANCEL;
                }
                dados.setSaidaApiTef(process.getSaidaApiTef());
                return ERRO;
            }
            catch (Exception e) {
                this.logger.log((Priority)Level.ERROR, (Object)e.getMessage(), (Throwable)e);
                return ERRO;
            }
        }
        return UNECESSARY;
    }
}

