/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IConsultaTransferenciaDomestica;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicConsultaTransferenciaDomestica {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IConsultaTransferenciaDomestica dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setNumeroTransacao(dados.getEntradaIntegracao().getNumeroTransacao());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setValorTransacao(dados.getValorTransacao());
        EntradaCTFClientCtrl entradaIntegracao = dados.getEntradaIntegracao();
        if (entradaIntegracao != null) {
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        entrada.setTimeoutCtf(conf.getTimeOutDefault());
        entrada.setDocumentoDepositante(dados.getDocumentoDepositante());
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        dados.setEntradaApiTef(entrada);
        SaidaApiTefC saida = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora()));
            return ERROR;
        }
        if (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2') {
            conBaixaTecnica.persisteBaixaTecnica();
        }
        VerifyContentUtil.preencheDadosSaida(dados, saida);
        return SUCCESS;
    }

    protected String getCodigoTransacao(IConsultaTransferenciaDomestica dados) throws IllegalStateException {
        return "G0";
    }
}

