/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDesfazimentoOperacao;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class MicDesfazimentoOperacao {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDesfazimentoOperacao dado) throws ExcecaoApiAc {
        boolean multiTerminal = false;
        boolean delivery = false;
        if (dado.getEntradaIntegracao() != null) {
            multiTerminal = dado.getEntradaIntegracao().isMultiTerminal();
            delivery = dado.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            delivery = dado.getCodigoOrigemTransacao() == 1;
        }
        EntradaApiTefC entradaApiTefC = null;
        String key = dado.getEntradaIntegracao() != null ? String.valueOf(dado.getEntradaIntegracao().getNumeroTransacao()) : String.valueOf(dado.getNumeroTransacao());
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal || delivery ? dado.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        DadosConfirmacaoDesfazimento dadosConfirmacaoDesfazimento = null;
        try {
            dadosConfirmacaoDesfazimento = (DadosConfirmacaoDesfazimento)PersistService.getInstance().load(key, identTerminal, conf.getVersaoPathTerminal());
            if (dadosConfirmacaoDesfazimento.isModoVendaRemota() && (dadosConfirmacaoDesfazimento.getModoIntegracaoPOSTef() == 2 || dadosConfirmacaoDesfazimento.getModoIntegracaoPOSTef() == 3)) {
                this.logger.info((Object)"transacao executa em modo POSTef com confirmacao no POS habilitada. necessario executar cancelamento da transacao");
                CodigoErroIntegracao erroIntegracao = new CodigoErroIntegracao(20, "ERRO NO DESFAZIMENTO#USE O CANCELAMENTO");
                dado.setErroIntegracao(erroIntegracao);
                return ERROR;
            }
            if (conf.isConfirmarDesfazimento() && dado.getEntradaIntegracao().getOperacao() == 7 && !this.confirmaDesfazimento(dadosConfirmacaoDesfazimento, dado.getPerifericos())) {
                SaidaApiTefC saida = new SaidaApiTefC();
                saida.setRetorno(20);
                dado.setErroIntegracao(new CodigoErroIntegracao(5317, "OPERACAO CANCELADA"));
                return ERROR;
            }
        }
        catch (ExcecaoApiAc e) {
            this.logger.error((Object)("n\u00e3o foi poss\u00edvel recuperar os dados da transa\u00e7\u00e3o para realizar o desfazimento no terminal " + identTerminal), (Throwable)e);
        }
        entradaApiTefC = new EntradaApiTefC();
        if (dadosConfirmacaoDesfazimento != null) {
            entradaApiTefC.setOperacao(dadosConfirmacaoDesfazimento.getOperacao());
            entradaApiTefC.setNumeroTransacao(dadosConfirmacaoDesfazimento.getNumeroTransacao());
            entradaApiTefC.setDataCliente(dadosConfirmacaoDesfazimento.getDataCliente());
            entradaApiTefC.setNumeroSeriePin(dadosConfirmacaoDesfazimento.getNumeroSeriePin());
            entradaApiTefC.setTimeoutCtf(dadosConfirmacaoDesfazimento.getTimeout());
            entradaApiTefC.setTimestamp(dadosConfirmacaoDesfazimento.getTimestamp());
            if (dadosConfirmacaoDesfazimento.getTipoResposta() != null && !dadosConfirmacaoDesfazimento.getTipoResposta().equals("")) {
                entradaApiTefC.setTipoResposta(dadosConfirmacaoDesfazimento.getTipoResposta().charAt(0));
            }
            entradaApiTefC.setDadosFinaisChip(dadosConfirmacaoDesfazimento.getDadosFinaisChip());
            entradaApiTefC.setIssuerScriptResult(dadosConfirmacaoDesfazimento.getIssuerScriptResult());
            if (dadosConfirmacaoDesfazimento.getApplicationExpirationDate() != null) {
                entradaApiTefC.setApplicationExpirationDate(dadosConfirmacaoDesfazimento.getApplicationExpirationDate());
            }
        } else {
            entradaApiTefC = dado.getEntradaApiTef();
        }
        dado.setEntradaApiTef(entradaApiTefC);
        SaidaApiTefC saida = dado.getApitef().desfazimento(ident, entradaApiTefC);
        dado.setSaidaApiTef(saida);
        if (saida.getRetorno() != 0) {
            this.logger.error((Object)("n\u00e3o foi poss\u00edvel desfazer a transa\u00e7\u00e3o " + dadosConfirmacaoDesfazimento.getNumeroTransacao() + " para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf."));
            return FAIL;
        }
        return SUCESS;
    }

    private boolean confirmaDesfazimento(DadosConfirmacaoDesfazimento dadosDesfazimento, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay("DESFAZIMENTO DE TRANSACAO");
        displayModel.addLinha(new Linha(""));
        displayModel.addLinha(new Linha("NSU: " + StringUtil.completaString(dadosDesfazimento.getNsu() + "", 6, '0', 3), 0));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        displayModel.addLinha(new Linha("DATA DA VENDA: " + dateFormat.format(dadosDesfazimento.getDataCliente()), 0));
        if (dadosDesfazimento.getValorTransacao() != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
            displayModel.addLinha(new Linha("VALOR DA VENDA: " + decimalFormat.format(dadosDesfazimento.getValorTransacao()), 0));
        }
        displayModel.addLinha(new Linha("DESFAZER TRANSACAO?", 0, 2));
        displayModel.addLinha(new Linha("[1] - SIM"));
        displayModel.addLinha(new Linha("[2] - NAO"));
        boolean valorValido = false;
        while (!valorValido) {
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_TRANS_PENDENTE);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) continue;
            String value = eventoTeclado.getStringLida();
            if (value.equals("1")) {
                LayoutDisplay layoutDisplay = new LayoutDisplay("TRANSACAO DESFEITA", 1500L);
                perifericos.imprimeDisplay(layoutDisplay);
                return true;
            }
            if (!value.equals("2")) continue;
            return false;
        }
        return false;
    }
}

