/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDesfazimentoOperacao;
import com.csi.ctfclient.operacoes.model.DadosConfirmacaoDesfazimento;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.PersistService;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class MicDesfazimentoOperacaoGeral {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDesfazimentoOperacao dado) throws ExcecaoApiAc {
        boolean multiTerminal = false;
        boolean delivery = false;
        if (dado.getEntradaIntegracao() != null) {
            multiTerminal = dado.getEntradaIntegracao().isMultiTerminal();
            delivery = dado.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            delivery = dado.getCodigoOrigemTransacao() == 1;
        }
        EntradaApiTefC entradaApiTefC = null;
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal || delivery ? (dado.getEntradaIntegracao() != null ? dado.getEntradaIntegracao().getIdentTerminal() : dado.getIdentTerminal()) : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        try {
            int i;
            Collection dadosEntrada = PersistService.getInstance().loadAll(identTerminal, conf.getVersaoPathTerminal());
            if (dadosEntrada == null || dadosEntrada.isEmpty()) {
                SaidaApiTefC saida = new SaidaApiTefC();
                saida.setRetorno(0);
                dado.setSaidaApiTef(saida);
                return SUCESS;
            }
            ArrayList arrayContrario = dadosEntrada instanceof ArrayList ? (ArrayList)dadosEntrada : new ArrayList(dadosEntrada);
            DadosConfirmacaoDesfazimento dadosDesfazimento = null;
            entradaApiTefC = new EntradaApiTefC();
            SaidaApiTefC saida = null;
            for (i = arrayContrario.size() - 1; i >= 0; --i) {
                dadosDesfazimento = (DadosConfirmacaoDesfazimento)arrayContrario.get(i);
                entradaApiTefC.setOperacao(dadosDesfazimento.getOperacao());
                entradaApiTefC.setNumeroTransacao(i + 1);
                entradaApiTefC.setDataCliente(dadosDesfazimento.getDataCliente());
                entradaApiTefC.setNumeroSeriePin(dadosDesfazimento.getNumeroSeriePin());
                entradaApiTefC.setTimeoutCtf(dadosDesfazimento.getTimeout());
                entradaApiTefC.setTimestamp(dadosDesfazimento.getTimestamp());
                if (dadosDesfazimento.getTipoResposta() != null && !dadosDesfazimento.getTipoResposta().equals("")) {
                    entradaApiTefC.setTipoResposta(dadosDesfazimento.getTipoResposta().charAt(0));
                }
                entradaApiTefC.setDadosFinaisChip(dadosDesfazimento.getDadosFinaisChip());
                entradaApiTefC.setIssuerScriptResult(dadosDesfazimento.getIssuerScriptResult());
                if (dadosDesfazimento.getApplicationExpirationDate() != null) {
                    entradaApiTefC.setApplicationExpirationDate(dadosDesfazimento.getApplicationExpirationDate());
                }
                if ((saida = dado.getApitef().desfazimento(ident, entradaApiTefC)).getRetorno() != 0) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("defazimento da transa\u00e7\u00e3o " + dadosDesfazimento.getNumeroTransacao() + " para o terminal " + identTerminal + " realizada com sucesso."));
                }
                PersistService.getInstance().remove(Integer.toString(dadosDesfazimento.getNumeroTransacao()), identTerminal, conf.getVersaoPathTerminal());
            }
            dado.setSaidaApiTef(saida);
            if (saida.getRetorno() != 0) {
                this.logger.error((Object)("n\u00e3o foi poss\u00edvel desfazer a transa\u00e7\u00e3o " + (i + 1) + " (" + dadosDesfazimento.getNumeroTransacao() + ")" + " para o terminal " + identTerminal + ". verifique os arquivos de controle da Apiwebctf."));
                return FAIL;
            }
        }
        catch (ExcecaoApiAc e) {
            this.logger.error((Object)("n\u00e3o foi poss\u00edvel recuperar os dados da transa\u00e7\u00e3o para realizar o desfazimento total no terminal " + identTerminal), (Throwable)e);
            throw e;
        }
        return SUCESS;
    }
}

