/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDesfazimentoOperacaoTransacaoCorrente;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicDesfazimentoOperacaoTransacaoCorrente {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDesfazimentoOperacaoTransacaoCorrente dados) throws ExcecaoApiAc {
        boolean multiTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        EntradaApiTefC entradaApiTefC = dados.getEntradaApiTef();
        SaidaApiTefC saidaOriginal = dados.getSaidaApiTef();
        if (saidaOriginal != null) {
            entradaApiTefC.setNsuCtfTransacaoOriginal(saidaOriginal.getNsuCTF());
        }
        if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 0 && dados.getPinInfo() != null) {
            entradaApiTefC.setDecisaoChip(StringUtil.completaString(dados.getPinInfo().getDecisaoFinishChip() + "", 1, ' ', 3).toCharArray()[0]);
        }
        this.logger.info((Object)"enviando transa\u00e7\u00e3o de desfazimento");
        SaidaApiTefC saida = dados.getApitef().desfazimento(ident, entradaApiTefC);
        this.logger.info((Object)("transa\u00e7\u00e3o de desfazimento enviada: " + saida.getRetorno()));
        if (dados.getEntradaIntegracao() != null && (dados.getEntradaIntegracao().getOperacao() == 7 || dados.getEntradaIntegracao().getOperacao() == 191)) {
            dados.setSaidaApiTef(saida);
        }
        if (dados.getEntradaApiTef() != null) {
            this.logger.log((Priority)Level.DEBUG, (Object)("N\u00famero da transa\u00e7\u00e3o: " + dados.getEntradaApiTef().getNumeroTransacao()));
            this.logger.log((Priority)Level.DEBUG, (Object)("Motivo da rejei\u00e7\u00e3o: " + dados.getEntradaApiTef().getTipoResposta()));
        } else {
            this.logger.log((Priority)Level.DEBUG, (Object)"Motivo da rejei\u00e7\u00e3o n\u00e3o existente, entrada = null.");
        }
        if (dados.getEntradaApiTef() != null) {
            if (dados.getEntradaApiTef().getTipoResposta().equals("2")) {
                String mensagem = dados.getCartao() instanceof CartaoChip && ((CartaoChip)dados.getCartao()).getTipoRedeAdquirente() == 2 ? "TRANSACAO NEGADA LIGUE EMISSOR" : "TRANS. NAO AUT. PELO CARTAO";
                String mensagemFormatada = StringUtil.completaString("" + mensagem.length(), 4, '0', 3);
                dados.getSaidaApiTef().setDisplayCTF(mensagemFormatada + mensagem);
                dados.getSaidaApiTef().setRetorno(11);
            } else if (dados.getErrorCode() > 0) {
                String msg = StringUtil.completaString("" + "ERRO NO CARTAO COM CHIP".length(), 4, '0', 3);
                dados.getSaidaApiTef().setDisplayCTF(msg + "ERRO NO CARTAO COM CHIP");
                dados.getSaidaApiTef().setRetorno(20);
            }
        }
        return SUCCESS;
    }
}

