/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IConvenioCombustivelShell;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.controller.ProdutoConvenioCombustivel;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusPresetFusion;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicDetectaOperacaoAbastecimento {
    public static final String SUCCESS = "SUCCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String DESFAZER_PRE_VALIDACAO = "DESFAZER_PRE_VALIDACAO";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR = "ERROR";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IConvenioCombustivelShell dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (dados.isPosAutorizado()) {
            if (dados.getTipoOperacao().equals("OPE_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO")) {
                this.logger.log((Priority)Level.ERROR, (Object)"Pr\u00e9-valida\u00e7\u00e3o selecionada, por\u00e9m est\u00e1 em modo conting\u00eancia");
                LayoutDisplay displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha(inter.getMessage("RECINFABA_ERROR_PRE_VALIDACAO_FUSION_OFFLINE1")));
                displayModel.addLinha(new Linha(inter.getMessage("RECINFABA_ERROR_PRE_VALIDACAO_FUSION_OFFLINE2")));
                perifericos.confirmaDado(displayModel);
                dados.setErroIntegracao(new CodigoErroIntegracao(5306, MSG_OPERATION_NOT_ALLOWED));
                return ERROR;
            }
            return NOT_REQUIRED;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
        perifericos.imprimeDisplay(displayModel);
        ControladorFusion fusion = ControladorFusion.getInstancia();
        String hashCartao = CriptografiaUtil.gerarHash(dados.getCartao().getPAN(), "SHA-256");
        StatusPresetFusion statusPreset = null;
        try {
            statusPreset = fusion.statusPreset(hashCartao);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (statusPreset == null) {
            dados.setErroIntegracao(new CodigoErroIntegracao(5393, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        if (statusPreset.getResultado() == 0) {
            ArrayList<String> mensagensErro = new ArrayList<String>();
            switch (statusPreset.getStatusPreset()) {
                case 1: {
                    if (dados.getTipoOperacao().equals("OPE_CONVENIO_COMBUSTIVEL_AUTORIZACAO")) {
                        this.logger.log((Priority)Level.ERROR, (Object)"Abastecimento ainda n\u00e3o realizado");
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO"));
                        break;
                    }
                    String mensagemDesfazerAbastecimento = statusPreset.getBomba() != null && statusPreset.getBomba().getId() > 0 ? "BOMBA " + statusPreset.getBomba().getId() + " LIBERADA, REFAZER LIBER?" : inter.getMessage("DETOPEABA_DESFAZER_ABASTECIMENTO_AUTORIZADO_TITLE");
                    LayoutMenu layoutMenu = new LayoutMenu(mensagemDesfazerAbastecimento, true);
                    layoutMenu.addItem(new ItemMenu(inter.getMessage("DETOPEABA_DESFAZER_ABASTECIMENTO_AUTORIZADO_SIM"), "1"));
                    layoutMenu.addItem(new ItemMenu(inter.getMessage("DETOPEABA_DESFAZER_ABASTECIMENTO_AUTORIZADO_NAO"), "2"));
                    int opcao = perifericos.imprimeMenu(layoutMenu);
                    if (opcao == -1) {
                        return USER_CANCEL;
                    }
                    if (opcao == 1) {
                        StatusFusion statusFusion = null;
                        try {
                            statusFusion = fusion.cancelarPreset(hashCartao);
                        }
                        catch (Exception e) {
                            this.logger.log((Priority)Level.WARN, (Object)"Erro ao cancelar o preset");
                            e.printStackTrace();
                        }
                        if (statusFusion == null || statusFusion.getResultado() != 0) {
                            this.logger.log((Priority)Level.WARN, (Object)("Erro ao cancelar o preset, resultado: " + statusFusion.getResultado() + ", status: " + statusFusion.getStatusFusion()));
                        }
                        return DESFAZER_PRE_VALIDACAO;
                    }
                    if (opcao == 2) {
                        this.logger.log((Priority)Level.ERROR, (Object)"Abastecimento ainda n\u00e3o realizado");
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO"));
                        return USER_CANCEL_INTERNAL;
                    }
                    throw new IllegalArgumentException("Op\u00e7\u00e3o de menu inexistente");
                }
                case 5: {
                    if (dados.getTipoOperacao().equals("OPE_CONVENIO_COMBUSTIVEL_AUTORIZACAO")) {
                        this.logger.log((Priority)Level.ERROR, (Object)"Abastecimento ainda n\u00e3o realizado");
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO"));
                        break;
                    }
                    displayModel = new LayoutDisplay();
                    displayModel.addLinha(new Linha("REFAZENDO AUTORIZACAO DA BOMBA..."));
                    displayModel.setDelay(1500L);
                    perifericos.imprimeDisplay(displayModel);
                    StatusFusion statusFusion = null;
                    try {
                        statusFusion = fusion.cancelarPreset(hashCartao);
                    }
                    catch (Exception e) {
                        this.logger.log((Priority)Level.WARN, (Object)"Erro ao cancelar o preset");
                        e.printStackTrace();
                    }
                    if (statusFusion == null || statusFusion.getResultado() != 0) {
                        this.logger.log((Priority)Level.WARN, (Object)("Erro ao cancelar o preset, resultado: " + statusFusion.getResultado() + ", status: " + statusFusion.getStatusFusion()));
                    }
                    return DESFAZER_PRE_VALIDACAO;
                }
                case 2: {
                    this.logger.log((Priority)Level.ERROR, (Object)"Autoriza\u00e7\u00e3o em abastecimento");
                    mensagensErro.add(inter.getMessage("RECINFABA_ERROR_ABASTECENDO"));
                    break;
                }
                case 3: {
                    this.logger.log((Priority)Level.ERROR, (Object)"Bomba bloqueada");
                    mensagensErro.add(inter.getMessage("RECINFABA_ERROR_BLOQUEADO"));
                    break;
                }
                case 4: {
                    if (dados.getTipoOperacao().equals("OPE_CONVENIO_COMBUSTIVEL_PRE_VALIDACAO")) {
                        this.logger.log((Priority)Level.ERROR, (Object)"Abastecimento pronto, por\u00e9m foi selecionado fazer outra pr\u00e9-valida\u00e7\u00e3o");
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO_SELECIONADO_PRE_VALIDACAO1"));
                        mensagensErro.add(inter.getMessage("RECINFABA_ERROR_AUTORIZADO_SELECIONADO_PRE_VALIDACAO2"));
                        break;
                    }
                    ProdutoConvenioCombustivel produto = new ProdutoConvenioCombustivel();
                    produto.setCodigo(statusPreset.getCodigoProduto());
                    ArrayList listProdutoConvenioCombustivel = new ArrayList();
                    dados.setListProdutoConvenioCombustivel(listProdutoConvenioCombustivel);
                    dados.setLitros(statusPreset.getVolumeFinal());
                    dados.setValorTransacao(statusPreset.getPrecoFinal());
                    dados.setPrecoUnitarioLitroCombustivel(statusPreset.getPrecoUnitario());
                    dados.setHashCartao(hashCartao);
                    dados.setCodigoAutorizacaoFusion(statusPreset.getCodigoAutorizacaoFusion());
                    return SUCCESS;
                }
                default: {
                    this.logger.log((Priority)Level.ERROR, (Object)("Retorno do status do preset n\u00e3o esperado: [" + statusPreset.getStatusPreset() + "]"));
                }
            }
            if (mensagensErro.size() == 0) {
                mensagensErro.add(inter.getMessage("RECINFABA_ERROR_DEFAULT"));
            }
            displayModel = new LayoutDisplay();
            Iterator iteErros = mensagensErro.iterator();
            while (iteErros.hasNext()) {
                displayModel.addLinha(new Linha((String)iteErros.next()));
            }
            perifericos.confirmaDado(displayModel);
            dados.setErroIntegracao(new CodigoErroIntegracao(5306, MSG_OPERATION_NOT_ALLOWED));
            return ERROR;
        }
        if (statusPreset.getResultado() == 2) {
            if (dados.getTipoOperacao().equals("OPE_CONVENIO_COMBUSTIVEL_AUTORIZACAO")) {
                this.logger.log((Priority)Level.ERROR, (Object)"Autoriza\u00e7\u00e3o selecionada, por\u00e9m foi realizada uma pr\u00e9-valida\u00e7\u00e3o");
                displayModel = new LayoutDisplay(inter.getMessage("RECINFABA_ERROR_PRE_VALIDACAO_SELECIONADO_AUTORIZACAO"));
                perifericos.confirmaDado(displayModel);
                dados.setErroIntegracao(new CodigoErroIntegracao(5306, MSG_OPERATION_NOT_ALLOWED));
                return ERROR;
            }
            return SUCCESS;
        }
        this.logger.log((Priority)Level.ERROR, (Object)("Erro ao tentar recuperar as informa\u00e7\u00f5es do abastecimento, c\u00f3digo: " + statusPreset.getResultado()));
        dados.setErroIntegracao(new CodigoErroIntegracao(5393, "ERRO CONEXAO FUSION"));
        return ERROR;
    }
}

