/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDados1F;
import com.csi.ctfclient.operacoes.entrada.IDados1FConsultaAvsMultiTerminal;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class MicEnvio1FConsultaAvsMultiTerminal
extends MicAbstractEnvio1F {
    private static final String CODIGO_TRANSACAO = "D6";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDados1FConsultaAvsMultiTerminal dados) throws ExcecaoApiAc {
        Produto[] produtos;
        EntradaApiTefC entrada = new EntradaApiTefC();
        if (dados.getCartao() instanceof CartaoDigitado) {
            Calendar calender = GregorianCalendar.getInstance();
            calender.setTime(new Date());
            calender.add(5, 1);
            entrada.setDataVencimento(calender.getTime());
        }
        dados.setEntradaApiTef(entrada);
        String retorno = super.execute(dados);
        if (retorno.equals("SUCESS") && (produtos = dados.getSaidaApiTef().getProdutos()) != null && produtos.length != 0) {
            if (produtos.length > 1) {
                this.logger.error((Object)"N\u00famero de produtos inv\u00e1lido. N\u00e3o \u00e9 poss\u00edvel processar a transa\u00e7\u00e3o");
                CodigoErroIntegracao erroIntegracao = new CodigoErroIntegracao(5306, "OPERACAO  NAO PERMITIDA");
                dados.setErroIntegracao(erroIntegracao);
                retorno = "ERRO";
            } else {
                dados.setProdutoSelecionado(produtos[0]);
            }
        }
        return retorno;
    }

    protected String getCodigoTransacao(IDados1F dados1F) throws IllegalStateException {
        return CODIGO_TRANSACAO;
    }
}

