/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDados1F;
import com.csi.ctfclient.operacoes.entrada.IDadosConsultaCartao;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicEnvio1FConsultaCartao
extends MicAbstractEnvio1F {
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosConsultaCartao dados) throws ExcecaoApiAc {
        EntradaApiTefC entrada = dados.getEntradaApiTef();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (entrada == null) {
            entrada = new EntradaApiTefC();
        }
        if (dados.getValorTransacao() == null) {
            BigDecimal valorTransacao = dados.getEntradaIntegracao().isValorTransacaoCtrl() ? dados.getEntradaIntegracao().getValorTransacao() : new BigDecimal(1);
            dados.setValorTransacao(valorTransacao);
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isUtilizaSaldoVoucherCtrl()) {
            this.logger.log((Priority)Level.INFO, (Object)("Pagamento com saldo do voucher (AC): " + dados.getEntradaIntegracao().isUtilizaSaldoVoucher()));
            entrada.setPagamentoComSaldoVoucher(dados.getEntradaIntegracao().isUtilizaSaldoVoucher());
        } else {
            this.logger.log((Priority)Level.INFO, (Object)("Pagamento com saldo do voucher (Config Client): " + conf.isPermitePagarSaldoVoucher()));
            entrada.setPagamentoComSaldoVoucher(conf.isPermitePagarSaldoVoucher());
        }
        dados.setSaidaApiTef(new SaidaApiTefC());
        dados.setEntradaApiTef(entrada);
        return super.execute(dados);
    }

    protected String getCodigoTransacao(IDados1F dados1F) throws IllegalStateException {
        EntradaCTFClientCtrl entradaIntegracao = dados1F.getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isCodigoTransacaoCtrl()) {
            return entradaIntegracao.getCodigoTransacao();
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }
}

