/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDados1F;
import com.csi.ctfclient.operacoes.entrada.IDados1FCorrespondenteBancario;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;

public class MicEnvio1FCorrespondenteBancario
extends MicAbstractEnvio1F {
    private String codigoTransacao;

    public String execute(IDados1FCorrespondenteBancario dados) throws ExcecaoApiAc {
        if (dados.getSaidaApiTef() != null && dados.getSaidaApiTef().getRetorno() == 0 && dados.getEntradaApiTef() != null && dados.getEntradaApiTef().getCodigoTransacao().equals("1F")) {
            return "UNECESSARY";
        }
        EntradaApiTefC entrada = dados.getEntradaApiTef();
        int modoEntrada = dados.getModoEntradaCodigoBarras();
        if (dados.getDataVencimentoCorBan() != null) {
            entrada.setDataVencimento(dados.getDataVencimentoCorBan());
        }
        String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(modoEntrada, dados.getCodigoBarras(), dados.getTipoPagamento());
        if (dados.getTipoPagamento() == 4 || dados.getTipoPagamento() == 5) {
            entrada.setDadosCorrespondenteBancario(entradaCorrespondenteBancario);
        } else if (dados.getTipoPagamento() == 1 || dados.getTipoPagamento() == 2) {
            entrada.setInfo(entradaCorrespondenteBancario);
        }
        dados.setEntradaApiTef(entrada);
        if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO")) {
            this.codigoTransacao = "E4";
        } else if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO")) {
            this.codigoTransacao = "E5";
        } else if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO TITULO")) {
            this.codigoTransacao = dados.getTipoPagamento() == 4 ? "2T" : (dados.getTipoPagamento() == 5 ? "EY" : "E6");
        } else if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO CONVENIO")) {
            this.codigoTransacao = dados.getTipoPagamento() == 4 ? "2P" : (dados.getTipoPagamento() == 5 ? "EZ" : "E7");
        } else if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO")) {
            this.codigoTransacao = dados.getTipoPagamento() == 4 ? "2T" : (dados.getTipoPagamento() == 5 ? "EY" : "E6");
        } else if (dados.getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO")) {
            this.codigoTransacao = dados.getTipoPagamento() == 4 ? "2P" : (dados.getTipoPagamento() == 5 ? "EZ" : "E7");
        } else {
            throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
        }
        return super.execute(dados);
    }

    protected String getCodigoTransacao(IDados1F dados1F) throws IllegalStateException {
        return this.codigoTransacao;
    }
}

