/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDados1F;
import com.csi.ctfclient.operacoes.entrada.IDados1FCreditoMultiTerminal;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class MicEnvio1FCreditoMultiTerminal
extends MicAbstractEnvio1F {
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDados1FCreditoMultiTerminal dados) throws ExcecaoApiAc {
        Produto[] protudos;
        EntradaApiTefC entrada = new EntradaApiTefC();
        if (dados.getCartao() instanceof CartaoDigitado) {
            Calendar calender = GregorianCalendar.getInstance();
            calender.setTime(new Date());
            calender.add(5, 1);
            entrada.setDataVencimento(calender.getTime());
        }
        dados.setEntradaApiTef(entrada);
        String retorno = super.execute(dados);
        if (retorno.equals("SUCESS") && (protudos = dados.getSaidaApiTef().getProdutos()) != null && protudos.length != 0) {
            if (protudos.length > 1) {
                this.logger.info((Object)"n\u00famero de produtos inv\u00e1lido. n\u00e3o \u00e9 poss\u00edvel processar a transa\u00e7\u00e3o");
                CodigoErroIntegracao erroIntegracao = new CodigoErroIntegracao(5306, "OPERACAO  NAO PERMITIDA");
                dados.setErroIntegracao(erroIntegracao);
                retorno = "ERRO";
            } else {
                dados.setProdutoDinamico(protudos[0]);
            }
        }
        return retorno;
    }

    protected String getCodigoTransacao(IDados1F dados1F) throws IllegalStateException {
        return "24";
    }
}

