/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDados1F;
import com.csi.ctfclient.operacoes.entrada.IDadosMenuDinamico;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicEnvio1FMenuDinamico
extends MicAbstractEnvio1F {
    public static final String UNECESSARY = "UNECESSARY";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosMenuDinamico dados) throws ExcecaoApiAc {
        EntradaApiTefC entrada = dados.getEntradaApiTef();
        if (dados.getSaidaApiTef() != null && dados.getSaidaApiTef().getRetorno() == 0) {
            return UNECESSARY;
        }
        if (entrada == null) {
            entrada = new EntradaApiTefC();
            dados.setEntradaApiTef(entrada);
        }
        if (dados.getCartao() instanceof CartaoDigitado) {
            Calendar calender = GregorianCalendar.getInstance();
            calender.setTime(new Date());
            calender.add(5, 1);
            entrada.setDataVencimento(calender.getTime());
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isUtilizaSaldoVoucherCtrl()) {
            this.logger.log((Priority)Level.INFO, (Object)("Pagamento com saldo do voucher (AC): " + dados.getEntradaIntegracao().isUtilizaSaldoVoucher()));
            entrada.setPagamentoComSaldoVoucher(dados.getEntradaIntegracao().isUtilizaSaldoVoucher());
        }
        if (dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isTipoAutorizadoraCtrl()) {
            this.logger.log((Priority)Level.INFO, (Object)("Tipo da autorizadora: " + dados.getEntradaIntegracao().getTipoAutorizadora()));
            entrada.setTipoAutorizadora(dados.getEntradaIntegracao().getTipoAutorizadora());
        }
        dados.setSaidaApiTef(new SaidaApiTefC());
        dados.setEntradaApiTef(entrada);
        return super.execute(dados);
    }

    protected String getCodigoTransacao(IDados1F dados1F) throws IllegalStateException {
        if ("CREDITO GENERICO".equals(dados1F.getTipoOperacao())) {
            if (dados1F.getCartao() instanceof CartaoDigitado) {
                return "24";
            }
            return "12";
        }
        if ("DEBITO GENERICO".equals(dados1F.getTipoOperacao())) {
            return "10";
        }
        if ("OUTRAS TRANSACOES".equals(dados1F.getTipoOperacao())) {
            return "2R";
        }
        if ("VOUCHER GENERICO".equals(dados1F.getTipoOperacao())) {
            return "6A";
        }
        if ("OPERACAO CONSULTA CDC COM PARCELA A VISTA".equals(dados1F.getTipoOperacao()) || "OPERACAO CONSULTA CDC SEM PARCELA A VISTA".equals(dados1F.getTipoOperacao())) {
            return "5C";
        }
        if ("OPERACAO CANCELAMENTO".equals(dados1F.getTipoOperacao())) {
            return "2W";
        }
        if ("OPE_DEBITO_CREDIARIO".equals(dados1F.getTipoOperacao())) {
            return "GB";
        }
        if ("OPE_CREDITO_CREDIARIO".equals(dados1F.getTipoOperacao())) {
            return "1S";
        }
        if ("OPE_SIMULACAO_CREDIARIO_CREDITO".equals(dados1F.getTipoOperacao())) {
            return "4F";
        }
        throw new IllegalStateException("Codigo transa\u00e7\u00e3o n\u00e3o encontrada!");
    }
}

