/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDados1F;
import com.csi.ctfclient.operacoes.entrada.IDadosTransacaoPagamentoFaturaCartao;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import java.math.BigDecimal;

public class MicEnvio1FPagamentoFaturaCartao
extends MicAbstractEnvio1F {
    public String execute(IDadosTransacaoPagamentoFaturaCartao dados) throws ExcecaoApiAc {
        EntradaApiTefC entrada = dados.getEntradaApiTef();
        if (entrada == null) {
            entrada = new EntradaApiTefC();
        }
        int modoEntrada = dados.getModoEntradaCodigoBarras();
        if (dados.getIdentificacaoPagamento() == 2) {
            String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(modoEntrada, dados.getCodigoBarras(), dados.getTipoPagamento());
            entrada.setInfo(entradaCorrespondenteBancario);
        }
        if (dados.getDataVencimentoCorBan() != null) {
            entrada.setDataVencimento(dados.getDataVencimentoCorBan());
        }
        if (dados.getDataVencimentoCorBan() != null) {
            entrada.setDataVencimentoCorrespondenteBancario(dados.getDataVencimentoCorBan());
        }
        if (dados.getValorAcrescimo() != null) {
            entrada.setValorAcrescimo(dados.getValorAcrescimo());
        } else {
            entrada.setValorAcrescimo(new BigDecimal(0));
        }
        if (dados.getValorDesconto() != null) {
            entrada.setValorDesconto(dados.getValorDesconto());
        } else {
            entrada.setValorDesconto(new BigDecimal(0));
        }
        entrada.setValorTransacao(dados.getValorTransacao());
        Cartao cartao = dados.getCartao();
        String retorno = super.execute(dados);
        if (cartao != null && !cartao.equals(dados.getCartao())) {
            dados.setCartao(cartao);
        }
        return retorno;
    }

    protected String getCodigoTransacao(IDados1F dados1f) throws IllegalStateException {
        if ("OPERACAO CONSULTA FATURA CARTAO".equals(dados1f.getTipoOperacao())) {
            return "FA";
        }
        if ("OPERACAO PAGAMENTO FATURA CARTAO".equals(dados1f.getTipoOperacao())) {
            return "FB";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

