/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDados1F;
import com.csi.ctfclient.operacoes.entrada.IDadosTransacaoCreditoDigital;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractEnvio1F;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.IdentTerminal;

public class MicEnvio1FRecargaTelefone
extends MicAbstractEnvio1F {
    private static final String CONSULTA_TELEFONE = "FH";
    private static final String CONSULTA_VALORES = "F4";
    private static final String RECARGA_TELEFONE = "F5";

    public String execute(IDadosTransacaoCreditoDigital dados) throws ExcecaoApiAc {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        IdentTerminal ident = new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(ident, config.getVersaoPathTerminal());
        if (!dadosInicioDia.isWkAuttarHabilitada()) {
            return "UNECESSARY";
        }
        EntradaApiTefC entradaApiTefC = new EntradaApiTefC();
        if (dados.getOperadoraTelefonia() != null) {
            entradaApiTefC.setInfo(dados.getOperadoraTelefonia().getAutorizadora());
            if (dados.getOperadoraTelefonia().getCodigo() != null) {
                entradaApiTefC.setOperadora(dados.getOperadoraTelefonia().getCodigo());
            }
        }
        dados.setEntradaApiTef(entradaApiTefC);
        return super.execute((IDados1F)((Object)dados));
    }

    protected String getCodigoTransacao(IDados1F dados1f) throws IllegalStateException {
        if ("CONSULTA DE CREDITO DIGITAL".equals(dados1f.getTipoOperacao())) {
            return CONSULTA_VALORES;
        }
        if ("COMPRA DE CREDITO DIGITAL".equals(dados1f.getTipoOperacao())) {
            return RECARGA_TELEFONE;
        }
        if ("CONSULTA TELEFONE CREDITO DIGITAL".equals(dados1f.getTipoOperacao())) {
            return CONSULTA_TELEFONE;
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

