/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ISolicitacaoReimpressao;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Date;

public class MicEnvio1FReimpressao {
    public static final String SUCESS = "SUCESS";
    public static final String FAIL = "FAIL";

    public String execute(ISolicitacaoReimpressao dado) throws ExcecaoApiAc, Exception {
        boolean delivery;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos conPerifericos = dado.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        EntradaApiTefC entrada = dado.getEntradaApiTef();
        entrada.setOperacao("1F");
        entrada.setDataTransacao(dado.getDataTransacao());
        entrada.setNsuCtfTransacaoOriginal(dado.getNsuTransacao());
        boolean bl = delivery = dado.getCodigoOrigemTransacao() == 1;
        if (!delivery && conPerifericos.getPin() != null) {
            if (conPerifericos.getPin().isBibliotecaEMV()) {
                entrada.setNumeroSeriePin(conPerifericos.getPin().getInfo().getNumSeriePinpad());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
            if (conBaixaTecnica.verificaNecessidadeBaixaTecnica(dado)) {
                entrada.setFlagBaixaTecnicaVisanet('2');
            }
        } else {
            entrada.setTipoPin("**");
        }
        Date dataAtual = new Date();
        entrada.setDataCliente(dataAtual);
        entrada.setTimeoutCtf(15);
        entrada.setOperacaoConsultada("F7");
        entrada.setNumeroTransacao(1);
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENV1FREI_REQUEST"));
        conPerifericos.imprimeDisplay(displayModel);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        dado.setSaidaApiTef(dado.getApitef().solicitacao(ident, entrada));
        SaidaApiTefC saida = dado.getSaidaApiTef();
        if (saida.getRetorno() == 0 && (saida.getFlagBaixaTecnica() == '1' || saida.getFlagBaixaTecnica() == '2')) {
            ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(true);
        } else {
            ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(false);
        }
        if (saida.getRetorno() == 0) {
            if (saida.getFlagCargaTabela() == '1') {
                CMOSPinPad.getInstance().solicitarCargaTabelas(saida.getRedeChip());
            }
            return SUCESS;
        }
        dado.setNsuTransacao(0);
        dado.setDataTransacao(null);
        return FAIL;
    }
}

