/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ICargaTabelasPinpad;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MicEnvio2M {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    private Logger logger = CTFClientLogger.getCTFClient();
    private int indicesAPular;

    public String execute(ICargaTabelasPinpad dado) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        PerifericoEventHandler.setActive(false);
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENV2M_ATUALIZANDO"));
        perifericos.imprimeDisplay(displayModel);
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setNumeroTransacao(0);
        entrada.setTimeoutCtf(15);
        entrada.setDataCliente(dado.getStartProcess());
        entrada.setOperacao("2M");
        ILeitorCartaoHandler leitorCartao = perifericos.getLeitorCartao();
        int redeChip = leitorCartao.getRedeAdquirente();
        if (leitorCartao != null) {
            entrada.setCodigoRedeAdquirenteChip(redeChip);
        }
        entrada.setCodigoRedeCargaTabelaPin("00");
        entrada.setIndiceCargaTabelaPin(0);
        entrada.setTipoBibliotecaPinpad(ProtocoloBibliotecaCompartilhada.getTipoBibliotecaPinpad());
        if (perifericos.getPin() != null) {
            entrada.setVersaoEspecificacao(perifericos.getPin().getInfo().getVersaoEspecificacao());
        }
        int retorno = 49;
        Vector v = new Vector(0);
        int retries = 0;
        int maxRetries = 3;
        do {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            IdentApiTefC ident = new IdentApiTefC();
            ident.setNumeroEstabelecimento(conf.getEstabelecimento());
            ident.setNumeroLoja(conf.getLoja());
            ident.setNumeroPdv(conf.getTerminal());
            ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
            ident.setListaIP(conf.getIps());
            ident.setQuantidadeVias(conf.getQuantidadeVias());
            int count = Integer.parseInt(new String(entrada.getIndiceCargaTabelaPin())) + 1;
            perifericos.imprimeDisplay(new LayoutDisplay(inter.getMessage("ENV2M_ATUALIZANDO") + " (" + count + ")"));
            SaidaApiTefC saida = dado.getApitef().solicitacao(ident, entrada);
            dado.setEntradaApiTef(entrada);
            dado.setSaidaApiTef(saida);
            if (saida.getRetorno() != 0) {
                if (retries < maxRetries) {
                    this.logger.warn((Object)("Erro na tentativa de carga de tabelas. Efetuando tentativa " + ++retries + " de " + maxRetries + "."));
                    continue;
                }
                CMOSPinPad.getInstance().refazerCargaTabelas(redeChip);
                ILeitorCartaoHandler cartaoHandler = null;
                if (perifericos.getLeitorCartao() != null) {
                    cartaoHandler = perifericos.getLeitorCartao();
                    cartaoHandler.setSolicitaCargaTabelas(LeitorCartaoEMV.ERRO_SOLICITA_CARGA_TABELA);
                }
                return ERRO;
            }
            retries = 0;
            this.indicesAPular = 0;
            retorno = saida.getFlagCargaTabela();
            if (!saida.getTabela1Pin().trim().equals("")) {
                v.addAll(this.converteDadosTabelaPin(saida.getTabela1Pin()));
            }
            if (!saida.getTabela2Pin().trim().equals("")) {
                v.addAll(this.converteDadosTabelaPin(saida.getTabela2Pin()));
            }
            if (!saida.getTabela3Pin().trim().equals("")) {
                v.addAll(this.converteDadosTabelaPin(saida.getTabela3Pin()));
            }
            --this.indicesAPular;
            entrada.setIndiceCargaTabelaPin(saida.getIndiceTabelaPin());
            entrada.setCodigoRedeCargaTabelaPin("00");
        } while (retorno != 48);
        dado.setConteudoTabelas(v);
        return SUCESS;
    }

    public Vector converteDadosTabelaPin(String registros) {
        int tam = 0;
        Vector<String> vector = new Vector<String>();
        if (registros == null) {
            return vector;
        }
        while (tam < registros.length()) {
            String strTam = registros.substring(tam, tam + 4);
            String strPin = registros.substring(tam + 4, tam + 7);
            int offset = Integer.parseInt(strTam);
            int offsetPin = Integer.parseInt(strPin);
            vector.add(registros.substring(tam += 4, offsetPin + tam));
            tam += offset;
            ++this.indicesAPular;
        }
        return vector;
    }
}

