/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoBaixaTecnicaManual;
import com.csi.ctfclient.operacoes.model.DadosBaixaTecnicaManual;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicEnvioTransacaoBaixaTecnicaManual {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String TEST = "TEST";
    private static final String OPERACAO = "2Y";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadoBaixaTecnicaManual dado) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dado.getPerifericos();
        DadosBaixaTecnicaManual dadoBaixaTecnicaManual = dado.getDadosBaixaTecnicaManual();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRABAITEC_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRABAITEC_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRABAITEC_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setOperacao(OPERACAO);
        entrada.setDataCliente(dado.getStartProcess());
        entrada.setTimestamp(new Date());
        entrada.setTipoPin("16");
        entrada.setTimeoutCtf(50);
        entrada.setNumeroTransacao(dado.getNumeroTransacao());
        SaidaGetInfoEMV saidaPin = periferico.getPin().getInfo();
        String numeroSeriePinAtual = saidaPin.getNumSeriePinpad().trim();
        String baixaTecnica = StringUtil.completaString(dadoBaixaTecnicaManual.getNumeroOS(), 8, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getIdentificacaoTecnico(), 5, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getNomeEstabelecimento(), 20, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getEnderecoEstabelecimento(), 20, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getTelefoneEstabelecimento(), 20, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(new SimpleDateFormat("ddMMyy").format(dadoBaixaTecnicaManual.getDataBaixaTecnica()), 6, '0', 3);
        baixaTecnica = baixaTecnica + StringUtil.completaString(new SimpleDateFormat("HHmm").format(dadoBaixaTecnicaManual.getDataBaixaTecnica()), 4, '0', 3);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getCodigoCarga(), 20, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getCodigoOcorrencia(), 8, ' ', 4);
        baixaTecnica = baixaTecnica + StringUtil.completaString(dadoBaixaTecnicaManual.getEPSCredenciada(), 20, ' ', 4);
        entrada.setBaixaTecnica(baixaTecnica);
        entrada.setNumeroSeriePin(numeroSeriePinAtual);
        entrada.setRetornoGetInfo(saidaPin.getRetorno());
        entrada.setClientSuportaPlataformaPromocional(true);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        SaidaApiTefC saidaApiTefC = dado.getApitef().solicitacao(ident, entrada);
        dado.setEntradaApiTef(entrada);
        dado.setSaidaApiTef(saidaApiTefC);
        if (dado.getSaidaApiTef().getRetorno() == 0) {
            return SUCESS;
        }
        this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora()));
        return ERRO;
    }
}

