/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoTransacaoContaDinheiro;
import com.csi.ctfclient.operacoes.model.Conta;
import com.csi.ctfclient.operacoes.model.ContaConvenio;
import com.csi.ctfclient.operacoes.model.ContaTitulo;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicEnvioTransacaoContaDinheiro {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_TRANS_JA_EFETUADA = "ERROR_TRANS_JA_EFETUADA";
    private Logger logger = CTFClientLogger.getCTFClient();

    protected String getCodigoTransacao(IDadoTransacaoContaDinheiro dado) throws IllegalStateException {
        if (dado.getConta() instanceof ContaTitulo) {
            return "E6";
        }
        if (dado.getConta() instanceof ContaConvenio) {
            return "E7";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encontrada");
    }

    public String execute(IDadoTransacaoContaDinheiro dado) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dado.getPerifericos();
        Conta conta = dado.getConta();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setOperacao(this.getCodigoTransacao(dado));
        entrada.setDataCliente(dado.getStartProcess());
        entrada.setTimeoutCtf(dado.getSaidaApiTef().getTimeOutCTF());
        entrada.setTimestamp(new Date());
        entrada.setValorTransacao(dado.getValorTransacao());
        entrada.setInfo(conta.getCodigoBarras());
        entrada.setDataVencimento(conta.getDataVencimento());
        if (conta.getValorAcrescimo().compareTo(new BigDecimal(0)) != 0) {
            entrada.setValorAcrescimo(conta.getValorAcrescimo());
        }
        if (conta.getValorDesconto().compareTo(new BigDecimal(0)) != 0) {
            entrada.setValorDesconto(conta.getValorDesconto());
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        SaidaApiTefC saidaApiTefC = dado.getApitef().solicitacao(ident, entrada);
        dado.setEntradaApiTef(entrada);
        dado.setSaidaApiTef(saidaApiTefC);
        if (dado.getSaidaApiTef().getRetorno() == 0) {
            VerifyContentUtil.preencheDadosSaida(dado, saidaApiTefC);
            return SUCESS;
        }
        this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora()));
        if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0ER")) {
            return ERROR_TRANS_JA_EFETUADA;
        }
        return ERROR;
    }
}

