/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IDadoTrasacaoCredito;
import com.csi.ctfclient.operacoes.microoperacoes.MicEnvioTrasacaoCredito;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;

public class MicEnvioTransacaoCreditoIATA
extends MicEnvioTrasacaoCredito {
    protected String getCodigoTransacao(IDadoTrasacaoCredito dado) throws IllegalStateException {
        if ("OPERACAO CREDITO IATA".equals(dado.getTipoOperacao())) {
            if (dado.getCartao() instanceof CartaoDigitado) {
                if (dado.getPlano() instanceof PlanoAVista) {
                    return "4B";
                }
                if (dado.getPlano() instanceof PlanoAdministradora) {
                    return "5E";
                }
                if (dado.getPlano() instanceof PlanoFinanciadoLojista) {
                    return "4E";
                }
            } else if (dado.getCartao() instanceof CartaoChip || dado.getCartao() instanceof CartaoMagnetico) {
                if (dado.getPlano() instanceof PlanoAVista) {
                    return "4A";
                }
                if (dado.getPlano() instanceof PlanoAdministradora) {
                    return "4D";
                }
                if (dado.getPlano() instanceof PlanoFinanciadoLojista) {
                    return "4C";
                }
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encontrada");
    }

    public String execute(IDadoTrasacaoCredito dado) throws ExcecaoApiAc {
        return super.execute(dado);
    }
}

