/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoECO;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicEnvioTransacaoECO {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    private static final String OPERACAO = "2S";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadoECO dado) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRAECO_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRAECO_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRAECO_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setOperacao(OPERACAO);
        entrada.setDataCliente(dado.getStartProcess());
        entrada.setTimestamp(new Date());
        entrada.setTimeoutCtf(15);
        if (periferico.getPin() != null) {
            if (periferico.getPin().isBibliotecaEMV()) {
                SaidaGetInfoEMV getInfoEMV = periferico.getPin().getInfo();
                entrada.setNumeroSeriePin(getInfoEMV.getNumSeriePinpad());
                entrada.setRetornoGetInfo(getInfoEMV.getRetorno());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        SaidaApiTefC saidaApiTefC = dado.getApitef().solicitacao(ident, entrada);
        dado.setEntradaApiTef(entrada);
        dado.setSaidaApiTef(saidaApiTefC);
        if (dado.getSaidaApiTef().getRetorno() == 0) {
            VerifyContentUtil.preencheDadosSaida(dado, saidaApiTefC);
            return SUCESS;
        }
        this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora()));
        return ERROR;
    }
}

