/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoTransacaoPreAutorizacao;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.PlanoCDC;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicEnvioTransacaoPreAutorizacao {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_TRANS_JA_EFETUADA = "ERROR_TRANS_JA_EFETUADA";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";
    private Logger logger = CTFClientLogger.getCTFClient();

    protected String getCodigoTransacao(IDadoTransacaoPreAutorizacao dados) throws IllegalStateException {
        if ("OPERACAO PRE AUTORIZACAO".equals(dados.getTipoOperacao())) {
            if (dados.getCartao() instanceof CartaoDigitado) {
                return "7D";
            }
            if (dados.getCartao() instanceof CartaoChip || dados.getCartao() instanceof CartaoMagnetico) {
                return "5F";
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    public String execute(IDadoTransacaoPreAutorizacao dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = new EntradaApiTefC();
        if (dados.getSaidaApiTef().isReenvioNegadaHost()) {
            if (dados.getEntradaApiTef().getDadosFinaisChip() != null) {
                entrada.setDadosFinaisChip(dados.getEntradaApiTef().getDadosFinaisChip());
            }
            if (dados.getEntradaApiTef().getIssuerScriptResult() != null) {
                entrada.setIssuerScriptResult(dados.getEntradaApiTef().getIssuerScriptResult());
            }
        } else if (!conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
            displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
            periferico.imprimeDisplay(displayModel);
        }
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        if (dados.getProdutoDinamico() != null) {
            Produto produto = dados.getProdutoDinamico();
            entrada.setCodigoProduto(produto.getCodigo());
            entrada.setCodigoBandeira(produto.getCodigoBandeira());
            entrada.setFluxoTef(produto.getKeyFluxo());
        } else {
            entrada.setCodigoProduto(0);
        }
        if (dados.getEntradaIntegracao() != null) {
            entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        entrada.setTimeoutCtf(dados.getSaidaApiTef().getTimeOutCTF());
        entrada.setTimestamp(new Date());
        entrada.setValorTransacao(dados.getValorTransacao());
        if (periferico.getPin() != null) {
            if (periferico.getPin().isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setRetornoGetInfo(dadoGetInfo.getCodigoRetorno());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                    entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                    entrada.setVersaoBibliotecaRedeEMV(dadoGetInfo.getVersaoBibRede4());
                    entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                    entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                    entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                    entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                }
                entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        if (dados.getCartao() instanceof AbstractCartao) {
            AbstractCartao cartaoGenerico = (AbstractCartao)dados.getCartao();
            if (cartaoGenerico.getTrilha1Criptografado() != null) {
                entrada.setTrilha1Criptografada(cartaoGenerico.getTrilha1Criptografado());
            }
            if (cartaoGenerico.getTrilha2Criptografado() != null) {
                entrada.setTrilha2Criptografada(cartaoGenerico.getTrilha2Criptografado());
            }
        }
        entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
        if (dados.getCartao() instanceof CartaoChip) {
            CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
            entrada.setModoEntrada(5);
            entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
            entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
            entrada.setNumeroAplicacao(cartaoChip.getNumero());
            entrada.setTipoCartao(cartaoChip.getTipoCartao());
            entrada.setIssuerCountryCode(cartaoChip.getIssuerCountry());
            entrada.setInfo(cartaoChip.getTrilha2().trim());
            entrada.setNomeCliente(cartaoChip.getNomePortador());
            entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
            entrada.setStatusChip(cartaoChip.getStatusUltimaLeitura());
            entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
            entrada.setWFlags(cartaoChip.getFlags());
            entrada.setPAN(cartaoChip.getNumero());
            if (cartaoChip.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoChip.getNumeroCriptografado());
            }
            entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
            entrada.setApplicationLabel(cartaoChip.getApplicationLabel());
        } else if (dados.getCartao() instanceof CartaoMagnetico) {
            CartaoMagnetico cartaoMagnetico = (CartaoMagnetico)dados.getCartao();
            entrada.setModoEntrada(2);
            entrada.setTipoAplicacaoChip(cartaoMagnetico.getTipoAplicacao());
            entrada.setTipoCartao(cartaoMagnetico.getTipoCartao());
            entrada.setInfo(cartaoMagnetico.getTrilha2().trim());
            entrada.setTrilha1(cartaoMagnetico.getTrilha1().trim());
            entrada.setStatusChip(cartaoMagnetico.getStatusUltimaLeitura());
            entrada.setIssuerCountryCode(cartaoMagnetico.getIssuerCountry());
            entrada.setNomeCliente(cartaoMagnetico.getNomePortador());
            entrada.setWFlags(cartaoMagnetico.getFlags());
            entrada.setPAN(cartaoMagnetico.getNumero());
            if (cartaoMagnetico.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoMagnetico.getNumeroCriptografado());
            }
        } else if (dados.getCartao() instanceof CartaoDigitado) {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            entrada.setModoEntrada(1);
            entrada.setInfo(cartaoDigitado.getNumero());
            entrada.setFallbackDigitado(cartaoDigitado.isFallback());
            if (cartaoDigitado.getVencimento() != null) {
                entrada.setDataVencimento(cartaoDigitado.getDateVencimento());
            }
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
            entrada.setPAN(cartaoDigitado.getNumero());
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
            if (dados.getEntradaIntegracao() != null) {
                entrada.setIdentificacaoTransacao(dados.getEntradaIntegracao().getCodigoOrigemTransacao());
            } else {
                entrada.setIdentificacaoTransacao(dados.getCodigoOrigemTransacao());
            }
            if (conf.isIntegracaoWeb()) {
                entrada.setIdentificacaoTransacao(2);
            }
        }
        if (dados.getTipoFinanciamento() instanceof PlanoAPrazo) {
            if (dados.getTipoFinanciamento() instanceof PlanoCDC) {
                PlanoCDC planoCDC = (PlanoCDC)dados.getTipoFinanciamento();
                entrada.setNumeroParcelas(planoCDC.getNumeroParcela());
                if (planoCDC.getValorEntrada() != null) {
                    entrada.setValorEntrada(planoCDC.getValorEntrada());
                }
            } else {
                PlanoAPrazo prazo = (PlanoAPrazo)dados.getTipoFinanciamento();
                entrada.setNumeroParcelas(prazo.getNumeroParcela());
            }
        } else {
            entrada.setNumeroParcelas(0);
        }
        if (dados.getServico() != null) {
            entrada.setValorTaxaServico(dados.getServico().getValorServico());
        }
        if (dados.getCodigoSeguranca() != null) {
            if (dados.getCodigoSeguranca().getCodigo().length() == 0) {
                if (dados.getCodigoSeguranca().getMotivo() == 0) {
                    entrada.setMotivoCVV2('2');
                } else {
                    entrada.setMotivoCVV2('9');
                }
            } else {
                entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            }
        }
        if (dados.getTaxaEmbarque() != null) {
            entrada.setValorTaxaEmbarque(dados.getTaxaEmbarque().getValorEmbarque());
        }
        entrada.setConfirmacaoPositiva(dados.getDadosConfirmacaoPositiva());
        PinInfo pinInfo = dados.getPinInfo();
        if (pinInfo != null) {
            this.logger.log((Priority)Level.DEBUG, (Object)("Status comunica\u00e7\u00e3o host: " + dados.getStatusComunicacaoHost()));
            if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                entrada.setDecisaoChip(StringUtil.completaString(pinInfo.getDecisaoFinishChip() + "", 1, ' ', 3).toCharArray()[0]);
                entrada.setStatusComunicacaoHost(dados.getStatusComunicacaoHost());
            } else {
                entrada.setDecisaoChip(pinInfo.getDecisaoTomada());
            }
            entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
            if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                entrada.setSenha(pinInfo.getPinCriptografado());
                if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                    entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                }
            }
            if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                EntradaApiTefC entradaFinishChip = dados.getEntradaApiTef();
                entrada.setDadosFinaisChip(entradaFinishChip.getDadosFinaisChip());
            } else if (pinInfo.getDadosCampo55() != null) {
                entrada.setDadosChip(pinInfo.getDadosCampo55());
            }
        }
        entrada.setInformacoesAdicionais(dados.getListInformacoesAdicionais());
        if (dados.getCodigoVoucherCtah() != null) {
            entrada.setCodigoVoucherCtah(dados.getCodigoVoucherCtah());
        }
        IdentTerminal identTerminal = null;
        if (conf.isIntegracaoWeb()) {
            identTerminal = dados.getEntradaIntegracao().getIdentTerminal();
            if (dados.getEntradaIntegracao() != null) {
                entrada.setCodigoAdquirenteWeb(dados.getEntradaIntegracao().getRedeAdquirente());
            }
        } else {
            identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        }
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
        if (tabelaCriptografia != null) {
            entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        if (periferico.getPin() != null && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
            conBaixaTecnica.persisteBaixaTecnica();
        }
        entrada.setNumeroCupom(dados.getNumeroCupom());
        entrada.setIndiceMasterKey(dados.getSaidaApiTef().getIndiceMasterKey());
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(ident, entrada);
        if (!dados.getSaidaApiTef().isReenvioNegadaHost()) {
            dados.setEntradaApiTef(entrada);
            dados.setSaidaApiTef(saidaApiTefC);
            if (dados.getSaidaApiTef().getRetorno() == 0) {
                VerifyContentUtil.preencheDadosSaida(dados, saidaApiTefC);
                return SUCESS;
            }
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora()));
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERROR_TRANS_JA_EFETUADA;
            }
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("077") && saidaApiTefC.isConfirnacaoPositiva()) {
                return CREDITO_REFERIDO;
            }
            return ERROR;
        }
        return SUCESS;
    }
}

