/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoTrasacaoCredito;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.IPlanoComEntrada;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.Plano;
import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import com.csi.ctfclient.operacoes.model.PlanoAVista;
import com.csi.ctfclient.operacoes.model.PlanoAdministradora;
import com.csi.ctfclient.operacoes.model.PlanoFinanciadoLojista;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicEnvioTrasacaoCredito {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    private Logger logger = CTFClientLogger.getCTFClient();

    protected String getCodigoTransacao(IDadoTrasacaoCredito dados) throws IllegalStateException {
        if ("OPERACAO CREDITO".equals(dados.getTipoOperacao())) {
            if (dados.getCartao() instanceof CartaoDigitado) {
                if (dados.getPlano() instanceof PlanoAVista) {
                    return "24";
                }
                if (dados.getPlano() instanceof PlanoAdministradora && ((PlanoAdministradora)dados.getPlano()).getNumeroParcela() > 1) {
                    return "25";
                }
                if (dados.getPlano() instanceof PlanoFinanciadoLojista && ((PlanoFinanciadoLojista)dados.getPlano()).getNumeroParcela() > 1) {
                    return "1E";
                }
                if (dados.getSaidaApiTef().isRotativoHabilitado()) {
                    return "24";
                }
            } else if (dados.getCartao() instanceof CartaoChip || dados.getCartao() instanceof CartaoMagnetico) {
                if (dados.getPlano() instanceof PlanoAVista) {
                    return "12";
                }
                if (dados.getPlano() instanceof PlanoAdministradora && ((PlanoAdministradora)dados.getPlano()).getNumeroParcela() > 1) {
                    return "22";
                }
                if (dados.getPlano() instanceof PlanoFinanciadoLojista && ((PlanoFinanciadoLojista)dados.getPlano()).getNumeroParcela() > 1) {
                    return "21";
                }
                if (dados.getSaidaApiTef().isRotativoHabilitado()) {
                    return "12";
                }
            }
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    public String execute(IDadoTrasacaoCredito dados) throws ExcecaoApiAc {
        PinInfo pinInfo;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ControladorBaixaTecnica conBaixaTecnica = null;
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        EntradaApiTefC entrada = new EntradaApiTefC();
        boolean multiTerminal = false;
        boolean delivery = false;
        if (dados.getEntradaIntegracao() != null) {
            multiTerminal = dados.getEntradaIntegracao().isMultiTerminal();
            boolean bl = delivery = dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
            if (dados.getEntradaIntegracao().isSoftDescriptorCtrl()) {
                entrada.setSoftDescriptor(dados.getEntradaIntegracao().getSoftDescriptor());
            }
            if (dados.getEntradaIntegracao().isMccCtrl()) {
                entrada.setMcc(dados.getEntradaIntegracao().getMcc());
            }
        } else {
            delivery = dados.getCodigoOrigemTransacao() == 1;
        }
        boolean connectedPin = false;
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = multiTerminal || delivery ? (dados.getEntradaIntegracao() != null ? dados.getEntradaIntegracao().getIdentTerminal() : dados.getIdentTerminal()) : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().getDadosComplementaresTef() != null) {
                entrada.setDadosComplementaresTef(dados.getEntradaIntegracao().getDadosComplementaresTef());
            }
            if (dados.getEntradaIntegracao().getTipoProduto() != null) {
                entrada.setTipoProduto(dados.getEntradaIntegracao().getTipoProduto());
            }
            if (dados.getEntradaIntegracao().isCodigoTabelaCtrl()) {
                entrada.setCodigoTabela(dados.getEntradaIntegracao().getCodigoTabela());
            } else if (conf.getCodigoTabela() > 0) {
                entrada.setCodigoTabela(conf.getCodigoTabela());
            }
        }
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setOperacao(this.getCodigoTransacao(dados));
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        if (!multiTerminal) {
            boolean bl = connectedPin = periferico.getPin() != null;
            if (dados.getSaidaApiTef().isReenvioNegadaHost()) {
                if (dados.getEntradaApiTef().getDadosFinaisChip() != null) {
                    entrada.setDadosFinaisChip(dados.getEntradaApiTef().getDadosFinaisChip());
                }
                if (dados.getEntradaApiTef().getIssuerScriptResult() != null) {
                    entrada.setIssuerScriptResult(dados.getEntradaApiTef().getIssuerScriptResult());
                }
            } else {
                LayoutDisplay displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
                displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
                displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
                periferico.imprimeDisplay(displayModel);
            }
            conBaixaTecnica = ControladorBaixaTecnica.getInstance();
            if (connectedPin && conBaixaTecnica.isBaixaTecnicaSolicitada()) {
                entrada.setFlagBaixaTecnicaVisanet('1');
                entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
                entrada.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
                conBaixaTecnica.persisteBaixaTecnica();
            }
        }
        entrada.setAcSuportaPlataformaPromocional(conf.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        if (dados.getEntradaIntegracao() != null) {
            if (dados.getEntradaIntegracao().isMultiTerminal()) {
                DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal, conf.getVersaoPathTerminal());
                entrada.setDataCliente(dadosInicioDia.getDataInicioDia());
            } else {
                entrada.setDataCliente(dados.getEntradaIntegracao().getDataAbertura());
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        if (connectedPin) {
            if (periferico.getPin().isBibliotecaEMV()) {
                if (dados.getDadosGetInfo() != null) {
                    GetInfo dadoGetInfo = dados.getDadosGetInfo();
                    entrada.setNumeroSeriePin(dadoGetInfo.getNumeroSerie());
                    entrada.setRetornoGetInfo(dadoGetInfo.getCodigoRetorno());
                    entrada.setVersaoBibliotecaCompartilhada(dadoGetInfo.getVersaoBibliotecaCompartilhada());
                    entrada.setVersaoEspecificacao(dadoGetInfo.getVersaoEspecificao());
                    entrada.setVersaoAplicacaoBasica(dadoGetInfo.getVersaoAplicacao());
                    entrada.setVersaoBibliotecaRedeEMV(dadoGetInfo.getVersaoBibRede4());
                    entrada.setFabricantePinpad(dadoGetInfo.getFabricante());
                    entrada.setModeloHardware(dadoGetInfo.getModeloHardware());
                    entrada.setVersaoRedeAdquirente(dadoGetInfo.getVersaoRedeAdquirente());
                    entrada.setVersaoKernelEMV(dadoGetInfo.getVersaoKernelEMV());
                }
                entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        entrada.setTimeoutCtf(dados.getSaidaApiTef().getTimeOutCTF());
        entrada.setTimestamp(new Date());
        entrada.setValorTransacao(dados.getValorTransacao());
        if (dados.getProdutoDinamico() != null) {
            Produto produto = dados.getProdutoDinamico();
            entrada.setCodigoProduto(produto.getCodigo());
            entrada.setCodigoBandeira(produto.getCodigoBandeira());
            entrada.setFluxoTef(produto.getKeyFluxo());
        } else {
            entrada.setCodigoProduto(0);
        }
        if (!(dados.getCartao() instanceof CartaoDigitado)) {
            AbstractCartao cartao = (AbstractCartao)dados.getCartao();
            if (cartao.getTrilha1Criptografado() != null) {
                entrada.setTrilha1Criptografada(cartao.getTrilha1Criptografado());
            }
            if (cartao.getTrilha2Criptografado() != null) {
                entrada.setTrilha2Criptografada(cartao.getTrilha2Criptografado());
            }
            entrada.setPAN(cartao.getNumero());
            if (cartao.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartao.getNumeroCriptografado());
            }
        }
        entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
        if (dados.getCartao() instanceof CartaoChip) {
            CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
            entrada.setModoEntrada(5);
            entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
            entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
            entrada.setNumeroAplicacao(cartaoChip.getNumero());
            entrada.setTipoCartao(cartaoChip.getTipoCartao());
            entrada.setIssuerCountryCode(cartaoChip.getIssuerCountry());
            entrada.setInfo(cartaoChip.getTrilha2().trim());
            entrada.setNomeCliente(cartaoChip.getNomePortador());
            entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
            entrada.setStatusChip(cartaoChip.getStatusUltimaLeitura());
            entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
            entrada.setWFlags(cartaoChip.getFlags());
            entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
            entrada.setApplicationLabel(cartaoChip.getApplicationLabel());
        } else if (dados.getCartao() instanceof CartaoMagnetico) {
            CartaoMagnetico cartaoMagnetico = (CartaoMagnetico)dados.getCartao();
            entrada.setModoEntrada(2);
            entrada.setTipoAplicacaoChip(cartaoMagnetico.getTipoAplicacao());
            entrada.setTipoCartao(cartaoMagnetico.getTipoCartao());
            entrada.setInfo(cartaoMagnetico.getTrilha2().trim());
            entrada.setTrilha1(cartaoMagnetico.getTrilha1().trim());
            entrada.setStatusChip(cartaoMagnetico.getStatusUltimaLeitura());
            entrada.setIssuerCountryCode(cartaoMagnetico.getIssuerCountry());
            entrada.setNomeCliente(cartaoMagnetico.getNomePortador());
            entrada.setWFlags(cartaoMagnetico.getFlags());
        } else if (dados.getCartao() instanceof CartaoDigitado) {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            entrada.setModoEntrada(1);
            entrada.setInfo(cartaoDigitado.getNumero());
            entrada.setFallbackDigitado(cartaoDigitado.isFallback());
            if (cartaoDigitado.getVencimento() != null) {
                entrada.setDataVencimento(cartaoDigitado.getDateVencimento());
            }
            entrada.setPAN(cartaoDigitado.getNumero());
            if (cartaoDigitado.getNumeroCriptografado() != null) {
                entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
            }
            if (dados.getEntradaIntegracao() != null) {
                entrada.setIdentificacaoTransacao(dados.getEntradaIntegracao().getCodigoOrigemTransacao());
            } else {
                entrada.setIdentificacaoTransacao(dados.getCodigoOrigemTransacao());
            }
            if (conf.isIntegracaoWeb()) {
                entrada.setIdentificacaoTransacao(2);
                if (dados.getEntradaIntegracao() != null) {
                    entrada.setCodigoAdquirenteWeb(dados.getEntradaIntegracao().getRedeAdquirente());
                }
            }
        }
        if (dados.getPlano() instanceof PlanoAVista) {
            PlanoAVista planoAVista = (PlanoAVista)dados.getPlano();
            if (planoAVista.getValorSaque() != null) {
                entrada.setValorCashBack(planoAVista.getValorSaque());
            }
            entrada.setNumeroParcelas(1);
        } else if (dados.getPlano() instanceof PlanoAPrazo) {
            BigDecimal valorEntrada;
            PlanoAPrazo prazo = (PlanoAPrazo)((Object)dados.getPlano());
            entrada.setNumeroParcelas(prazo.getNumeroParcela());
            if (dados.getPlano() instanceof IPlanoComEntrada && (valorEntrada = ((IPlanoComEntrada)((Object)dados.getPlano())).getValorEntrada()) != null) {
                entrada.setValorEntrada(valorEntrada);
            }
        }
        if (dados.getServico() != null) {
            entrada.setValorTaxaServico(dados.getServico().getValorServico());
        }
        if (dados.getCodigoSeguranca() != null) {
            if (dados.getCodigoSeguranca().getCodigo() == null || dados.getCodigoSeguranca().getCodigo().length() == 0) {
                if (dados.getCodigoSeguranca().getMotivo() == 0) {
                    entrada.setMotivoCVV2('2');
                } else {
                    entrada.setMotivoCVV2('9');
                }
            } else {
                entrada.setCvv2(dados.getCodigoSeguranca().getCodigo());
            }
        }
        if (dados.getTaxaEmbarque() != null) {
            entrada.setValorTaxaEmbarque(dados.getTaxaEmbarque().getValorEmbarque());
        }
        entrada.setConfirmacaoPositiva(dados.getDadosConfirmacaoPositiva());
        TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
        if (tabelaCriptografia != null) {
            entrada.setMetodoCriptografiaSenha(tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo());
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null) {
                entrada.setMetodoCriptografiaDados(tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo());
            }
        }
        if ((pinInfo = dados.getPinInfo()) != null) {
            this.logger.log((Priority)Level.DEBUG, (Object)("Status comunica\u00e7\u00e3o host: " + dados.getStatusComunicacaoHost()));
            if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                entrada.setDecisaoChip(StringUtil.completaString(pinInfo.getDecisaoFinishChip() + "", 1, ' ', 3).toCharArray()[0]);
                entrada.setStatusComunicacaoHost(dados.getStatusComunicacaoHost());
            } else {
                entrada.setDecisaoChip(pinInfo.getDecisaoTomada());
            }
            entrada.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            entrada.setChipBloqueadoOffline(pinInfo.isOfflineBloqueado());
            entrada.setAssinaturaChip(pinInfo.isRequerAssinatura());
            if (!(dados.getCartao() instanceof CartaoChip) || dados.getCartao() instanceof CartaoChip && dados.getSaidaApiTef().isFluxoChipNaoEMV() || dados.getCartao() instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                entrada.setSenha(pinInfo.getPinCriptografado());
                if (dados.getNumeroSerieChaveDUKPTSenha() != null) {
                    entrada.setNumeroSerieChaveSenha(dados.getNumeroSerieChaveDUKPTSenha());
                }
            }
            if (dados.getStatusComunicacaoHost() != null && dados.getStatusComunicacaoHost() == 1) {
                EntradaApiTefC entradaFinishChip = dados.getEntradaApiTef();
                entrada.setDadosFinaisChip(entradaFinishChip.getDadosFinaisChip());
            } else if (pinInfo.getDadosCampo55() != null) {
                entrada.setDadosChip(pinInfo.getDadosCampo55());
            }
        }
        entrada.setInformacoesAdicionais(dados.getListInformacoesAdicionais());
        entrada.setNumeroCupom(dados.getNumeroCupom());
        if (dados.getCodigoVoucherCtah() != null) {
            entrada.setCodigoVoucherCtah(dados.getCodigoVoucherCtah());
        }
        entrada.setIndiceMasterKey(dados.getSaidaApiTef().getIndiceMasterKey());
        if (connectedPin && !dados.getSaidaApiTef().isReenvioNegadaHost()) {
            periferico.getPin().setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        StringBuffer bit62Formatado = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        Cartao cartao = dados.getCartao();
        if (cartao != null && cartao.getEmissao() != null) {
            Date dataEmissaoDate = this.formataDataEmissao(cartao.getEmissao());
            bit62Formatado.append(simpleDateFormat.format(dataEmissaoDate));
            entrada.setDataEmissao(dataEmissaoDate);
        } else {
            bit62Formatado.append("00000000");
            entrada.setDataEmissao(null);
        }
        if (dados.getPlano() != null && dados.getPlano() instanceof Plano) {
            Plano plano = (Plano)((Object)dados.getPlano());
            if (plano.getNumeroCiclos() >= 0) {
                String ciclos = StringUtil.completaString(plano.getNumeroCiclos() + "", 2, '0', 3);
                bit62Formatado.append(ciclos);
                entrada.setNumeroCiclos(plano.getNumeroCiclos());
            } else {
                bit62Formatado.append("00");
                entrada.setNumeroCiclos(0);
            }
        }
        if (dados.getCodigoPreAutorizacao() != null) {
            bit62Formatado.append(StringUtil.completaString(dados.getCodigoPreAutorizacao(), 6, '0', 3));
            entrada.setCodigoAutorizacao(dados.getCodigoPreAutorizacao());
        }
        entrada.setAdicionais(bit62Formatado.toString());
        SaidaApiTefC saidaAtual = dados.getApitef().solicitacao(ident, entrada);
        if (dados.getSaidaApiTef().isFluxoChipNaoEMV()) {
            saidaAtual.setCapturaDadosChip(dados.getSaidaApiTef().getCapturaDadosChip());
        }
        if (!dados.getSaidaApiTef().isReenvioNegadaHost()) {
            dados.setEntradaApiTef(entrada);
            dados.setSaidaApiTef(saidaAtual);
            if (dados.getSaidaApiTef().getRetorno() == 0) {
                VerifyContentUtil.preencheDadosSaida(dados, saidaAtual);
                return SUCESS;
            }
            this.logger.log((Priority)Level.INFO, (Object)("Resposta autorizadora: " + saidaAtual.getCodigoRespostaAutorizadora()));
            if (saidaAtual.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            if (saidaAtual.getCodigoRespostaAutorizadora().equals("077") && saidaAtual.isConfirnacaoPositiva()) {
                return CREDITO_REFERIDO;
            }
            if (saidaAtual.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO_NAO_AUT_CARTAO;
            }
            return ERRO;
        }
        return SUCESS;
    }

    public Date formataDataEmissao(String value) {
        if (value.length() != 6) {
            throw new IllegalArgumentException("Data Invalida " + value);
        }
        try {
            int year = Integer.parseInt(value.substring(2));
            int month = Integer.parseInt(value.substring(0, 2));
            int day = 1;
            String dayString = StringUtil.completaString("" + day, 2, '0', 3);
            String dataString = StringUtil.completaString("" + month, 2, '0', 3);
            dataString = dataString + year;
            Date dateTemp = new SimpleDateFormat("ddMMyyyy").parse(dayString + dataString);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateTemp);
            String lasDayMonthString = String.valueOf(calendar.getActualMaximum(5));
            Date date = new SimpleDateFormat("ddMMyyyy").parse(lasDayMonthString + dataString);
            return date;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Data Invalida " + value);
        }
    }
}

