/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IEstatisticaLeituraCartao;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;

public class MicEstatisticaLeituraCartao {
    public static final String SUCESS = "SUCESS";
    private static final int PASSIVEL_FALLBACK = 1;

    public String execute(IEstatisticaLeituraCartao dados) {
        CartaoMagnetico cartaoMagnetico;
        Cartao cartao = dados.getCartao();
        if (cartao != null && cartao instanceof CartaoMagnetico && (cartaoMagnetico = (CartaoMagnetico)cartao).getStatusUltimaLeitura() == 1) {
            boolean persistirDados = false;
            try {
                ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                if (dados.getTipoOperacao().equals("OPERACAO CREDITO") || dados.getTipoOperacao().equals("CREDITO GENERICO") || dados.getTipoOperacao().equals("OPERACAO PRE AUTORIZACAO") || dados.getTipoOperacao().equals("OPERACAO CONFIRMACAO PRE AUTORIZACAO")) {
                    dadosEstatistica.addFallbackChipCredito();
                    persistirDados = true;
                } else if (dados.getTipoOperacao().equals("OPERACAO DEBITO") || dados.getTipoOperacao().equals("DEBITO GENERICO")) {
                    dadosEstatistica.addFallbackChipDebito();
                    persistirDados = true;
                }
                if (persistirDados) {
                    controladorEstatistica.persistirDados(dadosEstatistica);
                }
            }
            catch (ExcecaoApiAc e) {
                e.printStackTrace();
            }
        }
        return SUCESS;
    }
}

