/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.entrada.IEstatisticaVerificaComunicacaoCTF;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;

public class MicEstatisticaVerificaComunicacaoCTF {
    public static final String SUCESS = "SUCESS";
    public static final String ERROR = "ERROR";
    public static final String UNECESSARY = "UNECESSARY";

    public String execute(IEstatisticaVerificaComunicacaoCTF dados) {
        SaidaApiTefC saida = dados.getSaidaApiTef();
        try {
            boolean persistirDados = false;
            ControladorEstatistica controladorEstatistica = null;
            DadosEstatistica dadosEstatistica = null;
            if (saida.getCodigoRespostaAutorizadora().equals("055")) {
                controladorEstatistica = ControladorEstatistica.getInstance();
                dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                Cartao cartao = dados.getCartao();
                if (cartao instanceof CartaoMagnetico) {
                    dadosEstatistica.addErroSenhaPinMagnetico();
                    persistirDados = true;
                } else if (cartao instanceof CartaoChip) {
                    dadosEstatistica.addErroSenhaOnlineChip();
                    persistirDados = true;
                }
            }
            if (persistirDados) {
                controladorEstatistica.persistirDados(dadosEstatistica);
            }
        }
        catch (ExcecaoApiAc e) {
            e.printStackTrace();
            return ERROR;
        }
        return SUCESS;
    }
}

