/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IExibeCartaoPrepago;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicExibeDadosAtivacaoCartaoPrepago {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String UNECESSARY = "UNECESSARY";

    public String execute(IExibeCartaoPrepago dados) throws ExcecaoNaoLocal {
        if (dados.getEntradaIntegracao().getOperacao() == 273 && !dados.isSubFluxoConsulta()) {
            return UNECESSARY;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        ControladorPerifericos periferico = dados.getPerifericos();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        BigDecimal valorCartaoPrepago = saida.getValorCartaoPrepago();
        BigDecimal valorBonus = saida.getValorBonus();
        BigDecimal valorAtivacao = saida.getValorAcrescimo();
        BigDecimal valorDesconto = saida.getValorDesconto();
        BigDecimal valorPago = saida.getValorTransacao();
        LayoutDisplay displayModel = new LayoutDisplay(2);
        displayModel.addLinha(new Linha(inter.getMessage("EXIDADATIVCARPRE")));
        displayModel.addLinha(new Linha(""));
        displayModel.addLinha(new Linha("CREDITO CARTAO:" + StringUtil.completaString(format.format(valorCartaoPrepago.doubleValue()), 15, ' ', 3)));
        if (valorBonus != null) {
            displayModel.addLinha(new Linha("BONUS:         " + StringUtil.completaString(format.format(valorBonus.doubleValue()), 15, ' ', 3)));
        }
        if (valorAtivacao != null) {
            displayModel.addLinha(new Linha("TAXA ATIVACAO: " + StringUtil.completaString(format.format(valorAtivacao.doubleValue()), 15, ' ', 3)));
        }
        if (valorDesconto != null) {
            displayModel.addLinha(new Linha("DESCONTO:      " + StringUtil.completaString(format.format(valorDesconto.doubleValue()), 15, ' ', 3)));
        }
        displayModel.addLinha(new Linha("VALOR PAGO:    " + StringUtil.completaString(format.format(valorPago.doubleValue()), 15, ' ', 3)));
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            return SUCCESS;
        }
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        return SUCCESS;
    }
}

