/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosCancelamento;
import com.csi.ctfclient.operacoes.model.AbstractCartaoAtributosComuns;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicExibeDadosCancelamento {
    public static final String SUCESS = "SUCESS";
    public static final String ABORT = "ABORT";

    public String execute(IDadosCancelamento dados) throws ExcecaoApiAc {
        boolean multiTerminal;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        boolean bl = multiTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal();
        if (multiTerminal || !confCTFClient.isConfirmaCancelamento()) {
            return SUCESS;
        }
        SaidaApiTefC saida = dados.getSaidaApiTef();
        int nsuTransacao = dados.getNsuTransacao();
        String nsuTransacaoFormatado = StringUtil.completaString(String.valueOf(nsuTransacao), 6, '0', 3);
        Date dataTransacao = dados.getDataTransacao();
        ControladorPerifericos periferico = dados.getPerifericos();
        Cartao cartao = dados.getCartao();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        BigDecimal valorVenda = dados.getSaidaApiTef().getValorTransacao();
        String valorVendaFormatado = format.format(valorVenda.doubleValue());
        BigDecimal valorCancelamento = dados.getValorCancelamento();
        String valorCancelamentoFormatado = format.format(valorCancelamento.doubleValue());
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        LayoutDisplay displayModel = new LayoutDisplay(2);
        displayModel.addLinha(new Linha(inter.getMessage("EXIDADCAN_DADOS_OPERACAO")));
        int formatoCartao = 0;
        formatoCartao = saida.getCodigoVan() == 68 || saida.getCodigoVan() == 90 || saida.getCodigoVan() == 37 ? 2 : 1;
        if (cartao != null) {
            displayModel.addLinha(new Linha("CARTAO: " + cartao.getNumeroMascara(formatoCartao), 0, 1));
        } else if (dados.getSaidaApiTef().getNumeroCartao() != null && !dados.getSaidaApiTef().getNumeroCartao().equals("")) {
            String numeroCartao = dados.getSaidaApiTef().getNumeroCartao();
            String cartaoMascara = AbstractCartaoAtributosComuns.getNumeroMascara(numeroCartao, formatoCartao);
            displayModel.addLinha(new Linha("CARTAO: " + cartaoMascara, 0, 1));
        }
        displayModel.addLinha(new Linha("DATA: " + dateFormat.format(dataTransacao)));
        displayModel.addLinha(new Linha("VALOR VENDA: " + valorVendaFormatado));
        displayModel.addLinha(new Linha("VALOR A CANC: " + valorCancelamentoFormatado));
        displayModel.addLinha(new Linha("DOC: " + nsuTransacaoFormatado));
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            return SUCESS;
        }
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return ABORT;
        }
        return SUCESS;
    }
}

