/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.entrada.IDadosCorrespondenteBancario;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.controller.PinpadUtil;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicExibeDadosCorrespondenteBancario {
    public static final String SUCESS = "SUCESS";
    public static final String ABORT = "ABORT";
    public static final String ABORT_INTERNAL = "ABORT_INTERNAL";
    private static final String MSG_CONFIRMA_PINPAD = "CONFIRMA VALOR?";
    private static Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadosCorrespondenteBancario dados) throws ExcecaoNaoLocal, ExcecaoPerifericos {
        boolean multiTerminal;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean bl = multiTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal();
        if (multiTerminal) {
            return SUCESS;
        }
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (saida == null || saida != null && saida.isConfirmaDadosCorbanDisplayOperador()) {
            EventoTeclado eventoTeclado;
            logger.log((Priority)Level.INFO, (Object)"Confirma\u00e7\u00e3o dos dados utilizando o display do operador");
            ControladorPerifericos periferico = dados.getPerifericos();
            DecimalFormat format = new DecimalFormat("#,##0.00");
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
            LayoutDisplay displayModel = new LayoutDisplay(2);
            displayModel.addLinha(new Linha(inter.getMessage("EXIDADCORBAN_TITLE")));
            String linha1CodigoBarras = null;
            String linha2CodigoBarras = null;
            String codigoBarras = dados.getCodigoBarras();
            if (codigoBarras != null) {
                if (dados.getTipoConta() == 1) {
                    int posInicio = 0;
                    String cod1 = "";
                    String cod2 = "";
                    if (dados.getModoEntradaCodigoBarras() == 1) {
                        cod1 = cod1 + codigoBarras.substring(posInicio, posInicio + 5) + "." + codigoBarras.substring(posInicio + 5, posInicio + 10) + " ";
                        cod1 = cod1 + codigoBarras.substring(posInicio += 10, posInicio + 5) + "." + codigoBarras.substring(posInicio + 5, posInicio + 11);
                        cod2 = cod2 + codigoBarras.substring(posInicio += 11, posInicio + 5) + "." + codigoBarras.substring(posInicio + 5, posInicio + 11) + " ";
                        cod2 = cod2 + codigoBarras.substring(posInicio += 11, posInicio + 1) + " ";
                        cod2 = cod2 + codigoBarras.substring(++posInicio, posInicio + 14);
                        linha1CodigoBarras = cod1;
                        linha2CodigoBarras = cod2;
                    } else if (dados.getModoEntradaCodigoBarras() == 3 || dados.getModoEntradaCodigoBarras() == 3) {
                        String banco = codigoBarras.substring(posInicio, posInicio + 3);
                        String moeda = codigoBarras.substring(posInicio += 3, posInicio + 1);
                        String digito = codigoBarras.substring(++posInicio, posInicio + 1);
                        String fator = codigoBarras.substring(++posInicio, posInicio + 4);
                        String valor = codigoBarras.substring(posInicio += 4, posInicio + 10);
                        String campoLivre1 = codigoBarras.substring(posInicio += 10, posInicio + 5);
                        String campoLivre2 = codigoBarras.substring(posInicio += 5, posInicio + 10);
                        String campoLivre3 = codigoBarras.substring(posInicio += 10, posInicio + 10);
                        posInicio += 10;
                        cod1 = banco + moeda + campoLivre1.substring(0, 1) + "." + campoLivre1.substring(1, campoLivre1.length()) + "X" + " " + campoLivre2.substring(0, 5) + "." + campoLivre2.substring(5, campoLivre2.length()) + "X";
                        cod2 = campoLivre3 + "X" + " " + digito + " " + fator + valor;
                        linha1CodigoBarras = cod1;
                        linha2CodigoBarras = cod2;
                    }
                } else if (dados.getTipoConta() == 2) {
                    int tamanhoBloco = codigoBarras.length() == 48 ? 12 : 11;
                    int posInicio = 0;
                    String cod1 = "";
                    String cod2 = "";
                    cod1 = cod1 + codigoBarras.substring(posInicio, posInicio + tamanhoBloco) + " ";
                    cod1 = cod1 + codigoBarras.substring(posInicio += tamanhoBloco, posInicio + tamanhoBloco);
                    cod2 = cod2 + codigoBarras.substring(posInicio += tamanhoBloco, posInicio + tamanhoBloco) + " ";
                    cod2 = cod2 + codigoBarras.substring(posInicio += tamanhoBloco, posInicio + tamanhoBloco);
                    linha1CodigoBarras = cod1;
                    linha2CodigoBarras = cod2;
                }
            }
            String cedente = null;
            CorrespondenteBancario corban = dados.getCorrespondenteBancario();
            if (corban != null && corban.getCedente() != null && corban.getCedente().length() > 0) {
                cedente = corban.getCedente().trim();
            }
            String valorDocumentoFormatado = format.format(dados.getValorDocumento().doubleValue());
            String valorDevidoFormatado = format.format(dados.getValorTransacao().doubleValue());
            Date dataVencimento = dados.getDataVencimentoCorBan();
            String valorDescontoFormatado = null;
            BigDecimal valorDesconto = null;
            valorDesconto = dados.getValorDesconto() != null ? dados.getValorDesconto() : new BigDecimal(0);
            valorDescontoFormatado = format.format(valorDesconto.doubleValue());
            String valorAcrescimoFormatado = null;
            BigDecimal valorAcrescimo = null;
            valorAcrescimo = dados.getValorAcrescimo() != null ? dados.getValorAcrescimo() : new BigDecimal(0);
            valorAcrescimoFormatado = format.format(valorAcrescimo.doubleValue());
            if (linha1CodigoBarras != null && linha2CodigoBarras != null && !linha1CodigoBarras.equals("") && !linha2CodigoBarras.equals("")) {
                displayModel.addLinha(new Linha("CODIGO DE BARRAS:"));
                displayModel.addLinha(new Linha(" " + linha1CodigoBarras));
                displayModel.addLinha(new Linha(" " + linha2CodigoBarras));
            }
            if (cedente != null) {
                displayModel.addLinha(new Linha("CEDENTE: "));
                displayModel.addLinha(new Linha(" " + cedente));
            }
            displayModel.addLinha(new Linha("DATA:  " + dateFormat.format(dataVencimento)));
            displayModel.addLinha(new Linha("VALOR DOCUMENTO:  " + this.completaEspacosNumero(valorDocumentoFormatado)));
            boolean contemMotificador = false;
            if (valorDesconto.compareTo(new BigDecimal(0)) != 0) {
                displayModel.addLinha(new Linha("VALOR DESCONTOS:  " + this.completaEspacosNumero(valorDescontoFormatado)));
                contemMotificador = true;
            }
            if (valorAcrescimo.compareTo(new BigDecimal(0)) != 0) {
                displayModel.addLinha(new Linha("VALOR ACRESCIMOS: " + this.completaEspacosNumero(valorAcrescimoFormatado)));
                contemMotificador = true;
            }
            if (contemMotificador) {
                displayModel.addLinha(new Linha("VALOR TOTAL:      " + this.completaEspacosNumero(valorDevidoFormatado)));
            }
            if ((eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel)).getTeclaFinalizadora().equals("ENTRA")) {
                return SUCESS;
            }
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return ABORT;
            }
        } else {
            if (saida != null && saida.isConfirmaDadosCorbanPinpad()) {
                logger.log((Priority)Level.INFO, (Object)"Confirma\u00e7\u00e3o do valor utilizando o Pinpad");
                String mensagemPinpad = PinpadUtil.montaDisplayMensagemValor(MSG_CONFIRMA_PINPAD, dados.getValorTransacao(), true);
                return this.confirmaDadosPinpad(dados, inter.getMessage("EXIDADCORBAN_CONFIRMAR_TITLE"), mensagemPinpad);
            }
            logger.log((Priority)Level.INFO, (Object)"Nenhuma confirma\u00e7\u00e3o ser\u00e1 realizada");
        }
        return SUCESS;
    }

    private String completaEspacosNumero(String valor) {
        int digitos = 8;
        String valorFormatado = valor.length() < digitos ? StringUtil.completaString(valor, digitos, ' ', 3) : valor;
        return valorFormatado;
    }

    private String confirmaDadosPinpad(IDadosCorrespondenteBancario dados, String mensagemDisplay, String mensagemPinpad) throws ExcecaoPerifericos {
        Criptografia criptografia = null;
        try {
            ControladorPerifericos periferico = dados.getPerifericos();
            PinEMV pin = periferico.getPin();
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ProcessManager processManager = ProcessManager.getInstance();
        while (true) {
            ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(null, criptografia, null, false, false);
            processLeituraPin.setActiveDialogUserCancel(false);
            processLeituraPin.setTituloAguardaPin(mensagemDisplay);
            dados.getPerifericos().getPin().setMsgDisplay(mensagemPinpad);
            processLeituraPin.setTipoLeituraPin(3);
            try {
                processManager.subProcess(dados.getIdProcess(), processLeituraPin);
                if (processLeituraPin.getState() == 3 || processLeituraPin.getState() == 5) {
                    return ABORT_INTERNAL;
                }
                if (processLeituraPin.getState() == 1) {
                    return ABORT_INTERNAL;
                }
                if (processLeituraPin.getTeclaFuncaoPressionada() == 0) break;
            }
            catch (Exception e) {
                return ABORT_INTERNAL;
            }
        }
        return SUCESS;
    }
}

