/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.entrada.IDadosContaCartao;
import com.csi.ctfclient.operacoes.model.PagamentoConta;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicExibeDadosPagamentoContas {
    public static final String CONTINUE_READING = "CONTINUE_READING";
    public static final String FINISH_PAYMENT = "FINISH_PAYMENT";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static final String MSG_TITLE = "DADOS DO DOCUMENTO";
    private static final String OPE_CONTINUAR_PAGAMENTO = "CONTINUAR PAGAMENTO";
    private static final String OPE_FINALIZAR_PAGAMENTO = "FINALIZAR PAGAMENTO";

    public String execute(IDadosContaCartao dados) throws ExcecaoNaoLocal {
        DecimalFormat format = new DecimalFormat("#,##0.00");
        BigDecimal valorFinalDocumento = dados.getValorDocumento().add(dados.getValorAcrescimo()).subtract(dados.getValorDesconto());
        String valorDocumentoFormatado = format.format(valorFinalDocumento.doubleValue());
        String valorTotalFormatado = format.format(PagamentoConta.getValorTotalDocumentos(dados.getListPagamentoConta()));
        boolean dadoValido = false;
        int opcao = -1;
        while (!dadoValido) {
            LayoutDisplay displayModel = new LayoutDisplay(2);
            displayModel.addLinha(new Linha(MSG_TITLE));
            displayModel.addLinha(new Linha("VALOR:     " + valorDocumentoFormatado));
            displayModel.addLinha(new Linha("SUB TOTAL: " + valorTotalFormatado));
            displayModel.addLinha(new Linha("OPCAO"));
            displayModel.addLinha(new Linha("  [1] - CONTINUAR PAGAMENTO"));
            displayModel.addLinha(new Linha("  [2] - FINALIZAR PAGAMENTO"));
        }
        switch (opcao) {
            case 1: {
                return CONTINUE_READING;
            }
            case 2: {
                return FINISH_PAYMENT;
            }
        }
        return null;
    }
}

