/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IExibeValorResgateMonetario;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicExibeValorResgateMonetario {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    private Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IExibeValorResgateMonetario dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        if (saida == null || !saida.isResgateMonetario()) {
            return UNECESSARY;
        }
        BigDecimal valorOriginal = saida.getValorOriginalTransacao();
        BigDecimal valorTransacao = saida.getValorTransacao();
        if (valorOriginal == null || valorTransacao == null) {
            this.logger.log((Priority)Level.ERROR, (Object)("Valor original ou valor da transa\u00e7\u00e3o n\u00e3o preenchido. O desconto ser\u00e1 desconsiderado. Valor Orig: " + valorOriginal + ", Valor da transa\u00e7\u00e3o: " + valorTransacao));
            return UNECESSARY;
        }
        BigDecimal valorDesconto = valorOriginal.subtract(valorTransacao);
        this.logger.log((Priority)Level.INFO, (Object)("Valor do desconto: " + valorDesconto));
        dados.setValorDescontoMonetario(valorDesconto);
        ControladorPerifericos periferico = dados.getPerifericos();
        DecimalFormat format = new DecimalFormat("#,##0.00");
        String valorTransacaoFormatado = "R$ " + StringUtil.completaString(format.format(valorTransacao.doubleValue()), 12, ' ', 3);
        String valorOriginalFormatado = "R$ " + StringUtil.completaString(format.format(valorOriginal.doubleValue()), 12, ' ', 3);
        periferico.limpaDisplay();
        LayoutDisplay layoutDisplay = new LayoutDisplay(2, 5000L, true);
        if (saida.getDisplayResgateMonetario() != null && saida.getDisplayResgateMonetario().length() > 0) {
            layoutDisplay.addLinha(new Linha(saida.getDisplayResgateMonetario()));
            if (periferico.getPin() != null) {
                String mensagemPinpad = saida.getDisplayResgateMonetario().length() > 16 ? saida.getDisplayResgateMonetario().substring(0, 16) : saida.getDisplayResgateMonetario();
                periferico.getPin().setMsgDisplay(mensagemPinpad);
            }
        }
        layoutDisplay.addLinha(new Linha(inter.getMessage("EXIVALRESMON_VALOR_ORIGINAL")));
        layoutDisplay.addLinha(new Linha(valorOriginalFormatado));
        layoutDisplay.addLinha(new Linha(inter.getMessage("EXIVALRESMON_VALOR_COM_DESCONTO")));
        layoutDisplay.addLinha(new Linha(valorTransacaoFormatado));
        periferico.imprimeDisplay(layoutDisplay);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return SUCCESS;
    }
}

