/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.entrada.IConvenioCombustivelShell;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.StatusFusion;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicFinalizarPresetConvenioCombustivel {
    public static String SUCCESS_APROVADA = "SUCCESS_APROVADA";
    public static String SUCCESS_NEGADA = "SUCCESS_NEGADA";
    public static String ERROR = "ERROR";

    public String execute(IConvenioCombustivelShell dados) {
        Logger logger = CTFClientLogger.getCTFClient();
        SaidaApiTefC saida = dados.getSaidaApiTef();
        String hashCartao = dados.getHashCartao() != null ? dados.getHashCartao() : CriptografiaUtil.gerarHash(dados.getCartao().getPAN(), "SHA-256");
        ControladorFusion fusion = ControladorFusion.getInstancia();
        StatusFusion statusFusion = null;
        try {
            if (saida != null && saida.getRetorno() == 0) {
                logger.log((Priority)Level.INFO, (Object)"Transa\u00e7\u00e3o aprovada, confirmando preset...");
                statusFusion = fusion.finalizarPreset(hashCartao);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (statusFusion == null || statusFusion.getResultado() != 0) {
            if (statusFusion != null) {
                logger.log((Priority)Level.ERROR, (Object)("Erro ao finalizar o preset, c\u00f3digo: " + statusFusion.getResultado()));
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5393, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        if (saida != null && saida.getRetorno() == 0) {
            return SUCCESS_APROVADA;
        }
        return SUCCESS_NEGADA;
    }
}

