/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IJoinFinishChip;
import com.csi.ctfclient.operacoes.entrada.IRemoveCard;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicFinishChip {
    public static final String SUCESS_APROVADA = "SUCESS_APROVADA";
    public static final String SUCCESS_APROVADA_OFF = "SUCCESS_APROVADA_OFF";
    public static final String SUCESS_NEGADA_CARTAO = "SUCESS_NEGADA_CARTAO";
    public static final String NEGADA_CARTAO_OFF = "NEGADA_CARTAO_OFF";
    public static final String SUCESS_NEGADA_HOST = "SUCESS_NEGADA_HOST";
    public static final String SUCCESS_NEGADA_HOST_REENVIO = "SUCCESS_NEGADA_HOST_REENVIO";
    public static final String NOTREQUIRED = "NOTREQUIRED";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERRO = "ERRO";
    public static final String ERRO_PIN_PAD = "ERRO_PIN_PAD";
    public static final String ERRO_FINISH_CHIP = "ERRO_FINISH_CHIP";
    public static final String MSG_NEGADA_CARTAO = "TRANSACAO NAO AUTORIZADA          PELO CARTAO";
    private Logger logger = CTFClientLogger.getCTFClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(IJoinFinishChip dados) throws ExcecaoPerifericos {
        ControladorPerifericos perifericos = dados.getPerifericos();
        SaidaApiTefC saidaApiTefC = dados.getSaidaApiTef();
        if (!saidaApiTefC.isCapturaDadosChip()) return NOTREQUIRED;
        if (saidaApiTefC.isFluxoEMVSemFinishChip()) return NOTREQUIRED;
        if (dados.getPinInfo() == null) {
            return NOTREQUIRED;
        }
        if (dados.getPinInfo().getDecisaoTomada() == '1') {
            dados.setRemoveCardMessage(IRemoveCard.MSG_TRANS_NAO_AUT_CARTAO);
            return UNECESSARY;
        }
        PinEMV pinEMV = perifericos.getPin();
        if (saidaApiTefC.getRetorno() != 0 && saidaApiTefC.getRetorno() != 1 && saidaApiTefC.getRetorno() != 5) {
            if (saidaApiTefC.getRetorno() == 11) return UNECESSARY;
            if (saidaApiTefC.getStatusComunicacao() == 0) return UNECESSARY;
        }
        if (saidaApiTefC.getStatusComunicacao() == 0) {
            pinEMV.setComunicacaoHost(saidaApiTefC.getStatusComunicacao());
            pinEMV.setTipoEmissor(saidaApiTefC.getTipoEmissor());
            pinEMV.setAuthRespCode(saidaApiTefC.getCodigoRespostaAutorizadora());
            pinEMV.setCampo55(saidaApiTefC.getDadosRespostaChip());
            pinEMV.setDadosRestantes("");
            pinEMV.setTags(saidaApiTefC.getTagsFinais());
        } else {
            pinEMV.setComunicacaoHost(1);
            pinEMV.setTipoEmissor(0);
            pinEMV.setAuthRespCode("00");
            pinEMV.setCampo55("");
            pinEMV.setDadosRestantes("");
            pinEMV.setTags(dados.getTagsMandatorias());
        }
        EntradaApiTefC entrada = dados.getEntradaApiTef();
        SaidaFinishChipEMV chipEMV = null;
        try {
            chipEMV = pinEMV.finishChip();
            dados.setSaidaFinishChip(chipEMV);
            dados.setStatusComunicacaoHost(new Integer(pinEMV.getComunicacaoHost()));
            if (chipEMV.getRetorno() > 2) {
                dados.setRemoveCardMessage(chipEMV.getRetorno() + " - ERRO PIN PAD");
                return ERRO_PIN_PAD;
            }
            this.logger.log((Priority)Level.DEBUG, (Object)("Decis\u00e3o FinishiChip: " + chipEMV.getDecisao()));
            dados.getPinInfo().setDecisaoFinishChip(chipEMV.getDecisao());
            switch (chipEMV.getDecisao()) {
                case 0: {
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    dados.setRemoveCardMessage(IRemoveCard.MSG_TRANS_APROVADA);
                    if (pinEMV.getComunicacaoHost() != 1) return SUCESS_APROVADA;
                    return SUCCESS_APROVADA_OFF;
                }
                case 1: {
                    entrada.setTipoResposta('2');
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    if (pinEMV.getComunicacaoHost() == 1) {
                        entrada.setStatusComunicacaoHost(pinEMV.getComunicacaoHost());
                    }
                    if (saidaApiTefC.getRetorno() != 5 && saidaApiTefC.getRetorno() != 1) {
                        if (((CartaoChip)dados.getCartao()).getTipoRedeAdquirente() == 2) {
                            dados.setFinishChipMessage("TRANSACAO NEGADA LIGUE EMISSOR");
                        } else {
                            dados.setFinishChipMessage("TRANS. NAO AUT. PELO CARTAO");
                        }
                    }
                    if (((CartaoChip)dados.getCartao()).getTipoRedeAdquirente() == 2) {
                        dados.setRemoveCardMessage(IRemoveCard.REMCAR_TRANS_NAO_AUT_CARTAO_LIGUE_EMISSOR);
                    } else {
                        dados.setRemoveCardMessage(IRemoveCard.MSG_TRANS_NAO_AUT_CARTAO);
                    }
                    if (pinEMV.getComunicacaoHost() != 1) {
                        return SUCESS_NEGADA_CARTAO;
                    }
                    if (!entrada.getCodigoRedeAdquirenteChip().equals("03")) return NEGADA_CARTAO_OFF;
                    dados.setRemoveCardMessage("TENTE DE NOVO-TO");
                    return NEGADA_CARTAO_OFF;
                }
                case 2: {
                    if (saidaApiTefC.getMensagemDisplayPin().trim().equals("")) {
                        dados.setRemoveCardMessage(IRemoveCard.MSG_TRANS_NAO_APROV);
                    }
                    if (!saidaApiTefC.isReenvioNegadaHost()) return SUCESS_NEGADA_HOST;
                    if (chipEMV.getDadosFinais() == null || chipEMV.getDadosFinais().length() <= 0) {
                        if (chipEMV.getIssuerScriptResults() == null) return SUCESS_NEGADA_HOST;
                        if (chipEMV.getIssuerScriptResults().length() <= 0) return SUCESS_NEGADA_HOST;
                    }
                    entrada.setDadosFinaisChip(chipEMV.getDadosFinais());
                    entrada.setIssuerScriptResult(chipEMV.getIssuerScriptResults());
                    return SUCCESS_NEGADA_HOST_REENVIO;
                }
            }
            return ERRO;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!(e instanceof ExcecaoPerifericos)) return ERRO;
            if (dados.getSaidaApiTef().getRetorno() != 0) return ERRO;
            ExcecaoPerifericos erroPeriferico = (ExcecaoPerifericos)e;
            dados.setErrorCode(erroPeriferico.getCodigoErroOriginal());
            return ERRO_FINISH_CHIP;
        }
    }
}

