/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IHabilitaGoOnChip;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.operacoes.model.controller.PinpadUtil;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicHabilitaGoOnChip
implements ConstantesEMV {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";

    public String execute(IHabilitaGoOnChip dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("HAVGOONCHI_TITLE"));
        perifericos.imprimeDisplay(displayModel);
        SaidaApiTefC saida = dados.getSaidaApiTef();
        PinEMV pinEMV = perifericos.getPin();
        Criptografia cripto = dados.getCriptografia();
        pinEMV.setConstaListaNegra(saida.getListaNegra() == 1);
        pinEMV.setObrigaTransacaoOnline(saida.getConexao() == 1);
        pinEMV.setNovoValorTransacao(dados.getValorTotal().movePointRight(2).longValue());
        if (saida.isValorSaqueGoOnChip()) {
            pinEMV.setParcelaValorTransacao(dados.getValorSaque().movePointRight(2).longValue());
        } else {
            pinEMV.setParcelaValorTransacao(0L);
        }
        pinEMV.setTipoCriptografia(cripto.getModoCriptografia());
        pinEMV.setWorkingKey(cripto.getWorkingKey());
        pinEMV.setIndiceMasterKey(cripto.getIndiceMasterKey());
        pinEMV.setGerencRisco(saida.isRisco());
        pinEMV.setTermFloorLimit(saida.getFloorLimit());
        pinEMV.setTargetPercBiasedRandomSelection(saida.getPercentagem());
        pinEMV.setThresholdValueBiasedRandomSelection(saida.getValorLimite());
        pinEMV.setMaxTargetPerc(saida.getMaximaPercentagem());
        pinEMV.setReqPINTabelasServTEF(saida.isSenhaEasy());
        pinEMV.setTags(saida.getTagsMandatorias());
        pinEMV.setTagsOpt(saida.getTagsOpcionais());
        if (saida.getMensagemSenhaPinpad() != null) {
            String mensagemPin = PinpadUtil.montaDisplaySenha(dados.getValorTotal(), saida);
            pinEMV.setDadosRestantes(mensagemPin);
        }
        dados.setTagsMandatorias(saida.getTagsMandatorias());
        PerifericoEventHandler.setActive(true);
        pinEMV.habilita(1);
        return SUCESS;
    }
}

