/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IHabilitaLeitorCartao;
import com.csi.ctfclient.operacoes.model.Aid;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.DadosLeitorCartao;
import com.csi.ctfclient.tools.devices.ExcecaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.ExcecaoComunicacaoSegura;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicHabilitaLeitorCartao {
    private Logger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String CONFIGURA_PINPAD = "CONFIGURA_PINPAD";
    public static final String MSG_SEM_PINPAD = "999 - ERRO CONECTE PINPAD";
    public static final String MSG_ERRO_COMUNICACAO_SEGURA = "ERRO CHAVE";
    private static final int TIPO_APLICACAO_LISTA_ESPECIFICA = 0;
    private static final int TIPO_APLICACAO_CREDITO = 1;
    private static final int TIPO_APLICACAO_DEBITO = 2;
    private static final int TIPO_APLICACAO_QUALQUER = 99;

    public String execute(IHabilitaLeitorCartao dados) throws ExcecaoApiAc {
        boolean cartaoDigitado;
        boolean deliveryInternet;
        ILeitorCartaoHandler cartaoHandler = null;
        ControladorPerifericos perifericos = dados.getPerifericos();
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        boolean bl = deliveryInternet = dados.getCodigoOrigemTransacao() == 1 || dados.getCodigoOrigemTransacao() == 2;
        if (perifericos.getLeitorCartao() != null) {
            LayoutDisplay displayModel = new LayoutDisplay("AGUARDE...");
            perifericos.imprimeDisplay(displayModel);
        }
        boolean bl2 = cartaoDigitado = dados.getEntradaIntegracao() != null && (dados.getEntradaIntegracao().getOperacao() == 120 || dados.getEntradaIntegracao().getOperacao() == 121 || dados.getEntradaIntegracao().getOperacao() == 122 || dados.getEntradaIntegracao().getOperacao() == 302);
        if (deliveryInternet || perifericos.getLeitorCartao() == null || cartaoDigitado) {
            return UNECESSARY;
        }
        cartaoHandler = perifericos.getLeitorCartao();
        if (dados.getCartao() != null && dados.getCartao() instanceof CartaoDigitado) {
            return SUCESS;
        }
        LeitorCartaoEMV leitorEMV = (LeitorCartaoEMV)cartaoHandler.getLeitorCartao();
        leitorEMV.setIdRedeAdquirente(leitorEMV.getIdRedeAdquirente());
        if (leitorEMV.getIdRedeAdquirente() > 0 && leitorEMV.getIndiceAID() != null) {
            cartaoHandler.getRedeAdquirente();
            ArrayList<Aid> listAID = new ArrayList<Aid>();
            listAID.add(this.createAID(leitorEMV.getIdRedeAdquirente(), leitorEMV.getIndiceAID()));
            leitorEMV.setIdsRedeIndTab(listAID);
        } else {
            leitorEMV.setIdsRedeIndTab(dados.getListAID());
        }
        DadosLeitorCartao dadosLeitorCartao = (DadosLeitorCartao)((Object)cartaoHandler.getLeitorCartao());
        dadosLeitorCartao.setTipoAplicacao(this.infTipoAplicacao(dados));
        if (dados.getValorTransacao() != null) {
            dadosLeitorCartao.setValorInicialTransacao(this.infValorTransacao(dados.getValorTransacao()));
        }
        CMOSPinPad cmosPinPad = CMOSPinPad.getInstance();
        if (dados.getSaidaApiTef() != null && dados.getSaidaApiTef().getTipoBibliotecaPinpad() == 2) {
            dadosLeitorCartao.setTimeStamp(cmosPinPad.getTimeStamp(leitorEMV.getIdRedeAdquirente()));
        } else {
            dadosLeitorCartao.setTimeStamp(cmosPinPad.getTimeStamp(0));
        }
        dadosLeitorCartao.setDataTransacao(dados.getStartProcess());
        try {
            cmosPinPad = CMOSPinPad.getInstance();
            PerifericoEventHandler.setActive(true);
            cartaoHandler.habilitaTrilha(1);
            cartaoHandler.habilitaTrilha(2);
            cartaoHandler.habilitaTrilha(3);
            if (confCTFClient.getTentativasConexaoPinpad() == 0) {
                ExcecaoPerifericos ex;
                int cont = 0;
                do {
                    ++cont;
                    ex = null;
                    try {
                        cartaoHandler.habilita();
                    }
                    catch (ExcecaoPerifericos e) {
                        ex = e;
                        LayoutDisplay displayModel = new LayoutDisplay("Erro no PINPAD (" + cont + ")..");
                        perifericos.imprimeDisplay(displayModel);
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                } while (ex != null && cont < 10);
                if (ex != null) {
                    throw ex;
                }
            } else {
                cartaoHandler.habilita();
            }
            cmosPinPad.limpaTentativaConexoes();
        }
        catch (ExcecaoInteiroInvalido e) {
            this.logger.log((Priority)Level.ERROR, (Object)"Erro ao habilitar o leitor cart\u00e3o", (Throwable)e);
            perifericos.liberarRecursosPinCartao();
            dados.setErroIntegracao(new CodigoErroIntegracao(5327, MSG_SEM_PINPAD));
            return ERRO;
        }
        catch (ExcecaoBibliotecaCompartilhada e) {
            this.logger.log((Priority)Level.ERROR, (Object)"Erro ao habilitar o leitor cart\u00e3o", (Throwable)e);
            perifericos.liberarRecursosPinCartao();
            dados.setErroIntegracao(new CodigoErroIntegracao(5358, "PINPAD SEM API COMPARTILHADA"));
            return ERRO;
        }
        catch (ExcecaoComunicacaoSegura e) {
            this.logger.log((Priority)Level.ERROR, (Object)"Erro ao habilitar a comunica\u00e7\u00e3o segura com o pinpad", (Throwable)e);
            perifericos.liberarRecursosPinCartao();
            dados.setErroIntegracao(new CodigoErroIntegracao(5386, MSG_ERRO_COMUNICACAO_SEGURA));
            return ERRO;
        }
        catch (ExcecaoPerifericos e) {
            int qtdErro;
            this.logger.log((Priority)Level.ERROR, (Object)"Erro ao habilitar o leitor cart\u00e3o", (Throwable)e);
            perifericos.liberarRecursosPinCartao();
            dados.setErroIntegracao(new CodigoErroIntegracao(5327, MSG_SEM_PINPAD));
            if (confCTFClient.getTentativasConexaoPinpad() > 0 && (qtdErro = cmosPinPad.novaTentativaConexao()) >= confCTFClient.getTentativasConexaoPinpad()) {
                return CONFIGURA_PINPAD;
            }
            return ERRO;
        }
        return SUCESS;
    }

    private long infValorTransacao(BigDecimal bigDecimal) {
        return bigDecimal.movePointRight(2).longValue();
    }

    private int infTipoAplicacao(IHabilitaLeitorCartao dados) {
        int tipoAplicacao = 99;
        if ("OPERACAO CREDITO".equals(dados.getTipoOperacao()) || "CREDITO GENERICO".equals(dados.getTipoOperacao())) {
            tipoAplicacao = 1;
        } else if ("OPERACAO DEBITO".equals(dados.getTipoOperacao()) || "DEBITO GENERICO".equals(dados.getTipoOperacao()) || "OPE_DEBITO_CREDIARIO".equals(dados.getTipoOperacao())) {
            tipoAplicacao = 2;
        } else if ("OPERACAO IATA".equals(dados.getTipoOperacao()) || "OPERACAO AUTORIZACAO IATA".equals(dados.getTipoOperacao()) || "OPERACAO CREDITO IATA".equals(dados.getTipoOperacao())) {
            tipoAplicacao = 1;
        } else if ("OPERACAO RESGATE PREMIO LISTA AID".equals(dados.getTipoOperacao())) {
            tipoAplicacao = 0;
        } else if ("OPE_SIMULACAO_CREDIARIO_CREDITO".equals(dados.getTipoOperacao()) || "OPE_CREDITO_CREDIARIO".equals(dados.getTipoOperacao())) {
            tipoAplicacao = 1;
        } else if ("OPERACAO PRE AUTORIZACAO".equals(dados.getTipoOperacao()) || "OPERACAO CONFIRMACAO PRE AUTORIZACAO".equals(dados.getTipoOperacao())) {
            tipoAplicacao = 1;
        } else if ("OPERACAO CONSULTA FATURA CARTAO".equals(dados.getTipoOperacao()) || "OPERACAO PAGAMENTO FATURA CARTAO".equals(dados.getTipoOperacao())) {
            tipoAplicacao = 1;
        } else if ("OPERACAO CREDITO PRIVATE LABEL".equals(dados.getTipoOperacao())) {
            tipoAplicacao = 1;
        } else if ("OPERACAO CANCELAMENTO".equals(dados.getTipoOperacao()) && dados.getSaidaApiTef() != null && dados.getSaidaApiTef().getCodigoTransacao() != null) {
            String codigoTransacaoCancelamento = dados.getSaidaApiTef().getCodigoTransacao();
            if (codigoTransacaoCancelamento.equals("12")) {
                tipoAplicacao = 1;
            } else if (codigoTransacaoCancelamento.equals("10")) {
                tipoAplicacao = 2;
            }
        }
        return tipoAplicacao;
    }

    private Aid createAID(int redeAdquirente, Integer indiceAID) {
        Aid aid = new Aid();
        aid.setRede(StringUtil.completaString(String.valueOf(redeAdquirente), 2, '0', 3));
        aid.setIndice(StringUtil.completaString(String.valueOf(indiceAID), 2, '0', 3));
        return aid;
    }
}

