/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IInformaDadoPin;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.LeitorCartaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicHabilitaPin {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";

    public String execute(IInformaDadoPin dados) throws ExcecaoApiAc {
        String pan;
        ControladorPerifericos perifericos = dados.getPerifericos();
        PinEMV pinEMV = perifericos.getPin();
        Criptografia cripto = dados.getCriptografia();
        pinEMV.setTipoCriptografia(cripto.getModoCriptografia());
        pinEMV.setWorkingKey(cripto.getWorkingKey());
        pinEMV.setIndiceMasterKey(cripto.getIndiceMasterKey());
        if (dados.getSaidaApiTef() != null && dados.getSaidaApiTef().getPanTecBan() != null) {
            pan = dados.getSaidaApiTef().getPanTecBan();
            if (pan.length() < 13) {
                pan = StringUtil.completaString(pan, 13, '0', 3);
            }
            pinEMV.setNumeroCartao(pan);
            if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                pinEMV.setNumeroCartaoCripto(this.geraPan3DESReverso(pan));
            }
        } else if (cripto.isIndiceAuttar()) {
            String panVazio = "0000000000000";
            if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                String pan3DESReverso = StringUtil.completaString(panVazio, 16, 'F', 4);
                pan3DESReverso = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(pan3DESReverso, false);
                pinEMV.setNumeroCartao(pan3DESReverso);
            } else {
                pinEMV.setNumeroCartao(panVazio);
            }
        } else {
            pan = dados.getCartao().getPAN();
            if (pan.length() < 13) {
                pan = StringUtil.completaString(pan, 13, '0', 3);
            }
            pinEMV.setNumeroCartao(pan);
            if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                pinEMV.setNumeroCartaoCripto(this.geraPan3DESReverso(pan));
            }
        }
        if (dados.getDadosSolicitaPin() != null) {
            DadoSolicitaPin[] dadosPin = dados.getDadosSolicitaPin();
            pinEMV.resetParms();
            for (int i = 0; i < dadosPin.length; ++i) {
                pinEMV.addDadoSolicitaPin(dadosPin[i]);
            }
        }
        PerifericoEventHandler.setActive(true);
        pinEMV.habilita(dados.getTipoLeituraPin());
        return SUCESS;
    }

    private String geraPan3DESReverso(String pan) {
        if (pan.length() < 16) {
            pan = StringUtil.completaString(pan, 16, 'F', 4);
        }
        pan = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(pan, false);
        return pan;
    }
}

