/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.action.ProcessReimpressaoComprovante;
import com.csi.ctfclient.operacoes.entrada.IOpcoesImpressao;
import com.csi.ctfclient.operacoes.entrada.ISubProcessMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.ExibeDialog;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicImpressaoComprovantes {
    public static final String SUCESS_IMPRIME = "SUCESS_IMPRIME";
    public static final String SUCESS_DESFAZ = "SUCESS_DESFAZ";
    public static final String SUCESS_CONFIRMACAO = "SUCESS_CONFIRMACAO";
    public static final String SUCESS_SEM_CUPOM = "SUCESS_SEM_CUPOM";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO = "ERRO";
    private final String SEPARATOR = "--------------------------------------";

    public String execute(IOpcoesImpressao dado) throws ExcecaoApiAc, ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!dado.getSaidaApiTef().isCupomPresente()) {
            return SUCESS_CONFIRMACAO;
        }
        if (dado.getCupomCliente() == null || dado.getCupomCliente() == null) {
            return USERCANCEL;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = null;
        displayModel = ((ISubProcessMenu)((Object)dado)).getProcessMenu() instanceof ProcessReimpressaoComprovante ? new LayoutDisplay(inter.getMessage("IMPCOM_PRINTING")) : new LayoutDisplay(inter.getMessage("IMPCOM_PRINTING"), 0L, 1);
        perifericos.imprimeDisplay(displayModel);
        String[] buffer = null;
        String texto = "";
        for (int i = 0; i < dado.getOpcoesImpressao().length; ++i) {
            switch (dado.getOpcoesImpressao()[i]) {
                case 1: {
                    buffer = dado.getCupomCliente().getLinhas();
                    break;
                }
                case 2: {
                    buffer = dado.getCupomLojista().getLinhas();
                }
            }
            for (int j = 0; j < buffer.length; ++j) {
                texto = texto + buffer[j] + "\n";
            }
            texto = texto + "\n";
            if (i != 0) continue;
            texto = texto + "--------------------------------------";
            texto = texto + "\n\n";
        }
        dado.setOpcoesImpressao(new int[]{1, 2});
        ExibeDialog dlg = new ExibeDialog();
        dlg.setTitle("Comprovantes");
        dlg.setTextResumo(texto);
        dlg.show();
        if (dlg.getOption() == 1) {
            return SUCESS_IMPRIME;
        }
        if (dlg.getOption() == 2) {
            return SUCESS_CONFIRMACAO;
        }
        if (dlg.getOption() == 3) {
            return SUCESS_DESFAZ;
        }
        return ERRO;
    }
}

