/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadoTipoCartao;
import com.csi.ctfclient.operacoes.entrada.ISaidaApiTef;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emvfull.LeitorCartaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicLeituraCartao {
    public static final String SUCESS_CARDTYPE = "SUCESS_CARDTYPE";
    public static final String SUCESS_CARDCHIP = "SUCESS_CARDCHIP";
    public static final String SUCESS_CARDMAGNETIC = "SUCESS_CARDMAGNETIC";
    public static final String NECESSITA_CARGA_TABELA = "NECESSITA_CARGA_TABELA";
    public static final String ERRO_INVALID_NUMBER_TYPE = "ERRO_INVALID_NUMBER_TYPE";
    public static final String ERRO_INVALID_NUMBER_TYPE_AC = "ERRO_INVALID_NUMBER_TYPE_AC";
    public static final String ERRO_READCARD = "ERRO_READCARD";
    public static final String FILLED_CARDTYPE = "FILLED_CARDTYPE";
    public static final String FILLED_CARDCHIP = "FILLED_CARDCHIP";
    public static final String FILLED_CARDMAGNETIC = "FILLED_CARDMAGNETIC";
    public static final String ERRO = "ERRO";
    public static final String ERRO_CARDCHIP = "ERRO_CARDCHIP";
    public static final String ERRO_COMM = "ERRO_COMM";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_RETRY = "USERCANCEL_RETRY";
    public static final String REDIRECT_CREDITO_CELULAR = "REDIRECT_CREDITO_CELULAR";
    public static final String REDIRECT_IDENTIFICACAO_ASSOCIADO = "REDIRECT_IDENTIFICACAO_ASSOCIADO";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    private static final String MST_ERRO_VALID_CARD = "CARTAO INVALIDO";
    private static final String MST_ERRO_READ_CARD1 = "ERRO DE LEITURA";
    private static final String MST_ERRO_READ_CARD2 = "TENTE NOVAMENTE";
    private static final String MSG_ERRO_FALLBACK = "CARTAO DE FALLBACK DIFERE DO ORIGINAL";
    private static final String MST_ERRO_COMM1 = "VERIFIQUE PINPAD";
    private static Logger logger = CTFClientLogger.getCTFClient();

    public String execute(IDadoTipoCartao dado) throws ExcecaoApiAc, ExcecaoPerifericos {
        EventoTeclado teclado;
        boolean cartaoDigitado;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dado.getCartao() != null) {
            if (dado.getCartao() instanceof CartaoChip) {
                return FILLED_CARDCHIP;
            }
            if (dado.getCartao() instanceof CartaoDigitado) {
                return FILLED_CARDTYPE;
            }
            if (dado.getCartao() instanceof CartaoMagnetico) {
                return FILLED_CARDMAGNETIC;
            }
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().isNumeroCartaoCtrl()) {
            try {
                CartaoDigitado cartaoDigitado2 = new CartaoDigitado(dado.getEntradaIntegracao().getNumeroCartao());
                dado.setCartao(cartaoDigitado2);
                boolean connectedPin = false;
                if (perifericos.getPin() != null) {
                    connectedPin = true;
                }
                if (connectedPin && ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                    String pan3DESReverso = this.gera3DESReversoCartaoDigitado(cartaoDigitado2.getNumero());
                    cartaoDigitado2.setPanCripto(pan3DESReverso);
                }
                if (connectedPin && perifericos.getLeitorCartao() != null) {
                    perifericos.getLeitorCartao().desabilita();
                }
                dado.setErrorCode(-1);
                return SUCESS_CARDTYPE;
            }
            catch (IllegalArgumentException e) {
                dado.setErroIntegracao(new CodigoErroIntegracao(5301, MST_ERRO_READ_CARD1));
                return ERRO_INVALID_NUMBER_TYPE_AC;
            }
        }
        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().isMultiTerminal()) {
            dado.setErroIntegracao(new CodigoErroIntegracao(5301, inter.getMessage("LEICAR_CARTAO_INVALIDO")));
            return ERRO_INVALID_NUMBER_TYPE_AC;
        }
        EventoDispositivoEntrada evento = null;
        String msgDisplay = "";
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        boolean menuCreditoCelularHabilitado = false;
        if ((dado.getTipoOperacao() == "OPERACAO CREDITO" || dado.getTipoOperacao() == "CREDITO GENERICO") && config.isCreditoCelularHabilitado()) {
            menuCreditoCelularHabilitado = true;
        }
        if (perifericos.getPin() != null && dado.getCodigoOrigemTransacao() == 1) {
            perifericos.getPin().getInfo();
        }
        LayoutDisplay displayModel = null;
        boolean deliveryInternet = dado.getCodigoOrigemTransacao() == 1 || dado.getCodigoOrigemTransacao() == 2;
        boolean bl = cartaoDigitado = dado.getEntradaIntegracao() != null && (dado.getEntradaIntegracao().getOperacao() == 120 || dado.getEntradaIntegracao().getOperacao() == 121 || dado.getEntradaIntegracao().getOperacao() == 122 || dado.getEntradaIntegracao().getOperacao() == 302);
        do {
            if (perifericos.getLeitorCartao() != null && !deliveryInternet && !cartaoDigitado) {
                if (perifericos.getLeitorCartao().getSolicitaCargaTabelas() == LeitorCartaoEMV.CARGA_TABELA_OK && msgDisplay.trim().equals("")) {
                    if (dado.getTipoOperacao().equals("OPERACAO DEBITO")) {
                        displayModel = new LayoutDisplay(inter.getMessage("LEICAR_TITLE"));
                    } else if (dado.getStatusLeituraCartao() == 1) {
                        displayModel = new LayoutDisplay(inter.getMessage("LEICAR_TITLE"));
                    } else if (this.validaFallBack(dado)) {
                        if (perifericos.getLeitorCartao().getSolicitaCargaTabelas() == LeitorCartaoEMV.CARGA_TABELA_OK && msgDisplay.trim().equals("")) {
                            displayModel = new LayoutDisplay();
                            for (int i = 0; i < dado.getSaidaApiTef().getDisplayCTF().length; ++i) {
                                String[] mensagem = dado.getSaidaApiTef().getDisplayCTF()[i].split("#");
                                for (int x = 0; x < mensagem.length; ++x) {
                                    displayModel.addLinha(new Linha(mensagem[x]));
                                }
                            }
                        }
                    } else {
                        displayModel = new LayoutDisplay(inter.getMessage("LEICAR_TITLE"));
                    }
                } else {
                    PerifericoEventHandler.setActive(true);
                    if (!perifericos.getLeitorCartao().isHabilitado()) {
                        perifericos.getLeitorCartao().habilita();
                    }
                }
            } else {
                msgDisplay = inter.getMessage("LEICAR_TITLE_TYPED");
                displayModel = new LayoutDisplay(inter.getMessage("LEICAR_TITLE_TYPED"));
            }
            if (!msgDisplay.equals("")) {
                displayModel = new LayoutDisplay(msgDisplay);
            }
            boolean numeroPreenchido = false;
            while (!numeroPreenchido) {
                EventoTeclado eventoTeclado;
                String numeroDigitado;
                numeroPreenchido = true;
                long[] perifericosHabilitados = !cartaoDigitado ? new long[]{1L, 8L} : new long[]{1L};
                evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_CARTAO_DIGITADO, false, "", perifericosHabilitados);
                if (!(evento instanceof EventoTeclado) || !"ENTRA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) || (numeroDigitado = (eventoTeclado = (EventoTeclado)evento).getStringLida().substring(eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados())).length() != 0) continue;
                numeroPreenchido = false;
            }
        } while (evento instanceof EventoTeclado && "VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && !menuCreditoCelularHabilitado && perifericos.exibeMenuCancelamento() == 2);
        if (evento instanceof EventoTeclado && "VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && menuCreditoCelularHabilitado) {
            logger.log((Priority)Level.INFO, (Object)"Cr\u00e9dito com celular habilitado, redirecionando para fluxo de cr\u00e9dito com celular");
            dado.setSubfluxoCreditoCelular(true);
            if (perifericos.getLeitorCartao() != null) {
                perifericos.getLeitorCartao().desabilita();
            }
            return REDIRECT_CREDITO_CELULAR;
        }
        if (evento instanceof EventoTeclado && "VOLTA".equals((teclado = (EventoTeclado)evento).getTeclaFinalizadora())) {
            if (perifericos.getLeitorCartao() != null) {
                perifericos.getLeitorCartao().desabilita();
            }
            dado.setErrorCode(-1);
            return USERCANCEL;
        }
        if (evento instanceof EventoLeitorCartaoEMV) {
            EventoLeitorCartaoEMV eventoLeitorCartaoEMV = (EventoLeitorCartaoEMV)evento;
            switch (eventoLeitorCartaoEMV.getErroCodigo()) {
                case 13: {
                    dado.setErrorCode(-1);
                    return USERCANCEL;
                }
            }
            if (eventoLeitorCartaoEMV.getCartaoComErro()) {
                logger.debug((Object)("cartao com erro: " + eventoLeitorCartaoEMV.getErroCodigo()));
                dado.setLastErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                if (eventoLeitorCartaoEMV.getErroCodigo() == 100) {
                    dado.setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                    dado.setStatusLeituraCartao(1);
                    return ERRO_CARDCHIP;
                }
                if (eventoLeitorCartaoEMV.getErroCodigo() >= 50) {
                    dado.setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                    dado.setStatusLeituraCartao(1);
                    return ERRO_CARDCHIP;
                }
                switch (eventoLeitorCartaoEMV.getErroCodigo()) {
                    case 20: {
                        dado.setErrorCode(eventoLeitorCartaoEMV.getErroCodigo());
                        return NECESSITA_CARGA_TABELA;
                    }
                    case 41: {
                        this.exibeMensagemDuasLinhas(perifericos, MST_ERRO_READ_CARD1, MST_ERRO_READ_CARD2);
                        dado.setErrorCode(-1);
                        if (dado.getStatusLeituraCartao() == 1) {
                            dado.setStatusLeituraCartao(3);
                        }
                        if (dado.getEntradaIntegracao() != null && dado.getEntradaIntegracao().getOperacao() == 301) {
                            logger.log((Priority)Level.INFO, (Object)"Leitura de cart\u00e3o de uma Identifica\u00e7\u00e3o de associado associado com erro");
                            return REDIRECT_IDENTIFICACAO_ASSOCIADO;
                        }
                        return ERRO_READCARD;
                    }
                    case 31: {
                        this.exibeMensagemDuasLinhas(perifericos, MST_ERRO_COMM1, "");
                        dado.setErrorCode(-1);
                        return ERRO_COMM;
                    }
                }
                logger.debug((Object)"saida default");
                return ERRO;
            }
            if (this.validaCartao(perifericos, eventoLeitorCartaoEMV)) {
                logger.debug((Object)"saida verifica cart\u00e3o lido");
                return this.verificaCartaoLido(eventoLeitorCartaoEMV, dado);
            }
        } else if (evento instanceof EventoTeclado) {
            EventoTeclado eventoTeclado = (EventoTeclado)evento;
            String numeroDigitado = eventoTeclado.getStringLida().substring(eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados());
            try {
                CartaoDigitado cartao = null;
                cartao = dado.getStatusLeituraCartao() == 3 ? new CartaoDigitado(numeroDigitado, true) : new CartaoDigitado(numeroDigitado);
                if (this.validaCartaoAnterior(dado, cartao)) {
                    if (perifericos.getPin() != null) {
                        if (perifericos.getLeitorCartao() != null && !deliveryInternet && !cartaoDigitado) {
                            perifericos.getLeitorCartao().desabilita();
                        }
                        perifericos.getPin().setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
                        if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                            String pan3DESReverso = this.gera3DESReversoCartaoDigitado(cartao.getNumero());
                            cartao.setPanCripto(pan3DESReverso);
                        }
                    }
                    dado.setCartao(cartao);
                    dado.setErrorCode(-1);
                    return SUCESS_CARDTYPE;
                }
                dado.setErroIntegracao(new CodigoErroIntegracao(5399, MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
            catch (IllegalArgumentException e) {
                this.exibeMensagem(perifericos, MST_ERRO_VALID_CARD);
                return ERRO_INVALID_NUMBER_TYPE;
            }
        }
        logger.debug((Object)"saida cart\u00e3o n\u00e3o emv , teclado");
        return ERRO;
    }

    private boolean validaCartao(ControladorPerifericos perifericos, EventoLeitorCartaoEMV eventoLeitor) throws ExcecaoApiAc {
        if (eventoLeitor.getTrilha1() == null && eventoLeitor.getTrilha2() == null || eventoLeitor.getTrilha1().trim().equals("") && eventoLeitor.getTrilha2().trim().equals("")) {
            this.exibeMensagem(perifericos, MST_ERRO_VALID_CARD);
            return false;
        }
        return true;
    }

    private String verificaCartaoLido(EventoLeitorCartaoEMV eventoLeitor, IDadoTipoCartao dadoCartao) {
        String retorno = ERRO;
        AbstractCartao cartao = null;
        switch (eventoLeitor.getTipoCartao()) {
            case 0: {
                cartao = new CartaoMagnetico(eventoLeitor.getTrilha1(), eventoLeitor.getTrilha2(), eventoLeitor.getNomePortadorCartao(), eventoLeitor.getNumeroExternoCartao(), eventoLeitor.getPAN(), eventoLeitor.getPANCripto(), eventoLeitor.getPANTrilha1(), eventoLeitor.getPANTrilha2(), eventoLeitor.getTipoAplicacaoSelecionada(), eventoLeitor.getStatusUltLeitura(), eventoLeitor.getTipoCartao(), eventoLeitor.getIssuerCountryCode(), eventoLeitor.getFlags(), eventoLeitor.getPix(), eventoLeitor.getIdCred(), eventoLeitor.getDadosRestantes());
                dadoCartao.setErrorCode(-1);
                if (this.validaCartaoAnterior(dadoCartao, cartao)) {
                    retorno = SUCESS_CARDMAGNETIC;
                    break;
                }
                dadoCartao.setErroIntegracao(new CodigoErroIntegracao(5399, MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
            case 3: 
            case 4: {
                cartao = new CartaoChip(eventoLeitor.getTrilha1(), eventoLeitor.getTrilha2(), eventoLeitor.getNomePortadorCartao(), eventoLeitor.getNumeroExternoCartao(), eventoLeitor.getPAN(), eventoLeitor.getPANCripto(), eventoLeitor.getPANTrilha1(), eventoLeitor.getPANTrilha2(), eventoLeitor.getIssuerCountryCode(), eventoLeitor.getTipoCartao(), eventoLeitor.getIndiceRegistro(), eventoLeitor.getTipoAplicacaoSelecionada(), eventoLeitor.getTipoRedeAdquirente(), eventoLeitor.getPANSequenceNumber(), eventoLeitor.getStatusUltLeitura(), eventoLeitor.getFlags(), eventoLeitor.getPix(), eventoLeitor.getIdCred(), eventoLeitor.getDadosRestantes(), eventoLeitor.getAppExpirationDate(), eventoLeitor.getAppLabel());
                if (this.validaCartaoAnterior(dadoCartao, cartao)) {
                    retorno = SUCESS_CARDCHIP;
                    break;
                }
                dadoCartao.setErroIntegracao(new CodigoErroIntegracao(5399, MSG_ERRO_FALLBACK));
                return ERROR_FALLBACK;
            }
        }
        dadoCartao.setCartao(cartao);
        return retorno;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoApiAc {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        perifericos.confirmaDado(displayModel);
    }

    private void exibeMensagemDuasLinhas(ControladorPerifericos perifericos, String msg1, String msg2) throws ExcecaoApiAc {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.setDelay(1500L);
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        perifericos.imprimeDisplay(displayModel);
    }

    public boolean validaFallBack(ISaidaApiTef dados) throws ExcecaoApiAc {
        String operacao;
        return dados.getSaidaApiTef() != null && dados.getSaidaApiTef().getCodigoRespostaAutorizadora() != null && ((operacao = dados.getSaidaApiTef().getCodigoRespostaAutorizadora()).equals("F3") || operacao.equals("0F3"));
    }

    private boolean validaCartaoAnterior(IDadoTipoCartao dadoCartao, Cartao cartaoLido) {
        if (dadoCartao.getCartaoAnterior() != null) {
            return dadoCartao.getCartaoAnterior().getPAN().equals(cartaoLido.getPAN());
        }
        return true;
    }

    private String gera3DESReversoCartaoDigitado(String numeroCartao) {
        String panAbertoParaReverter;
        String restantePan = "";
        if (numeroCartao.length() < 16) {
            panAbertoParaReverter = StringUtil.completaString(numeroCartao, 16, 'F', 4);
        } else if (numeroCartao.length() > 16) {
            panAbertoParaReverter = numeroCartao.substring(0, 16);
            restantePan = numeroCartao.substring(16);
        } else {
            panAbertoParaReverter = numeroCartao;
        }
        String pan3DESReverso = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(panAbertoParaReverter, false);
        if (numeroCartao.length() > 16) {
            pan3DESReverso = pan3DESReverso + restantePan;
        }
        return pan3DESReverso;
    }
}

