/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IleituraGoOnChip;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicLeituraGoOnChip
implements ConstantesEMV {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    private Logger logger = CTFClientLogger.getPeriferico();

    public String execute(IleituraGoOnChip dados) throws ExcecaoNaoLocal, ExcecaoApiAc {
        ControladorPerifericos perifericos = dados.getPerifericos();
        EventoDispositivoEntrada evento = null;
        LayoutDisplay layoutDisplay = null;
        do {
            if (layoutDisplay != null) {
                perifericos.imprimeDisplay(layoutDisplay);
            }
            evento = perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_LEITURA_PIN, false, new long[]{1L, 4L});
            layoutDisplay = perifericos.getUltimoDisplay();
        } while (evento instanceof EventoTeclado && ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.exibeMenuCancelamento() == 2 || "ENTRA".equals(((EventoTeclado)evento).getTeclaFinalizadora())));
        if (evento instanceof EventoTeclado) {
            if (perifericos.getPin() != null) {
                BibliotecaPinpad pin = (BibliotecaPinpad)perifericos.getPin();
                pin.abort();
                dados.setErrorCode(0);
            }
            return USERCANCEL;
        }
        EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
        if (eventoPinEMV.getErroCodigo() == 13) {
            dados.setErrorCode(0);
            return USERCANCEL;
        }
        if (eventoPinEMV.getErroCodigo() == 50 || eventoPinEMV.getErroCodigo() == 60 || eventoPinEMV.getErroCodigo() == 61 || eventoPinEMV.getErroCodigo() == 70 || eventoPinEMV.getErroCodigo() == 76) {
            if (dados.getSaidaApiTef().isPermiteFallbackGoonchip()) {
                this.logger.debug((Object)"Fallback habilitado na GoOnChip");
                dados.setErrorCode(eventoPinEMV.getErroCodigo());
                PerifericoEventHandler.setActive(false);
                return ERROR_FALLBACK;
            }
            this.logger.log((Priority)Level.INFO, (Object)"Fallback na GoOnChip desabilitado");
        }
        if (eventoPinEMV.getErro()) {
            dados.setErrorCode(eventoPinEMV.getErroCodigo());
            if (dados.isPossuiChaveContingencia() && eventoPinEMV.getErroCodigo() == 42) {
                this.logger.log((Priority)Level.INFO, (Object)"Erro ao utilizar a criptografia principal de senha, a conting\u00eancia ser\u00e1 utilizada");
                return ERRO;
            }
            dados.setErroIntegracao(new CodigoErroIntegracao(5329, "ERRO NA CAPTURA DO CHIP"));
            return ERRO;
        }
        dados.setErrorCode(0);
        PinInfo pinInfo = new PinInfo();
        pinInfo.setPinCriptografado(eventoPinEMV.getCodigo());
        pinInfo.setDecisaoTomada(eventoPinEMV.getStatusAprovacaoTransacao());
        pinInfo.setRequerAssinatura(eventoPinEMV.getRequerAssinaturaPapel());
        pinInfo.setVerificadoOffline(eventoPinEMV.getPinVerificadoOffline());
        pinInfo.setNumApresentacoesInvalidasPinOff(eventoPinEMV.getNumApresentacoesInvalidasPinOff());
        pinInfo.setOfflineBloqueado(eventoPinEMV.getPinOfflineBloqueado());
        pinInfo.setNumeroSerieChaveDUKPT(eventoPinEMV.getNumeroSerieChaveDUKPT());
        pinInfo.setDadosCampo55(eventoPinEMV.getCampo55());
        pinInfo.setPinCriptografado(eventoPinEMV.getCodigo());
        pinInfo.setCapturadoVerificacaoOnline(eventoPinEMV.getPinCapturadoVerificacaoOnline());
        dados.setPinInfo(pinInfo);
        try {
            boolean persistirDados = false;
            ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
            DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
            if (pinInfo.isVerificadoOffline()) {
                dadosEstatistica.addSenhaOfflineChip();
                persistirDados = true;
            } else {
                dadosEstatistica.addSenhaOnlineChip();
                persistirDados = true;
            }
            for (int i = 0; i < pinInfo.getNumApresentacoesInvalidasPinOff(); ++i) {
                dadosEstatistica.addErroSenhaOfflineChip();
                persistirDados = true;
            }
            if (pinInfo.isOfflineBloqueado()) {
                dadosEstatistica.addCartoesBloqErroSenhaChip();
                persistirDados = true;
            }
            if (persistirDados) {
                controladorEstatistica.persistirDados(dadosEstatistica);
            }
        }
        catch (ExcecaoApiAc e) {
            this.logger.error((Object)"Erro ao contabilizar estat\u00edstica em MicLeituraPin: ", (Throwable)e);
        }
        return SUCESS;
    }
}

